package ru.yandex.msearch.proxy.api.async.suggest.rules;

import java.util.function.Function;

import org.apache.http.HttpHost;
import org.apache.http.nio.protocol.HttpAsyncRequestProducer;

import ru.yandex.http.util.AbstractFilterFutureCallback;
import ru.yandex.http.util.BadRequestException;
import ru.yandex.http.util.nio.BasicAsyncRequestProducerGenerator;

import ru.yandex.msearch.proxy.AsyncHttpServer;

import ru.yandex.msearch.proxy.api.async.mail.rules.PlainCallback;

import ru.yandex.msearch.proxy.api.async.mail.searcher.PlainSearcher;

import ru.yandex.msearch.proxy.api.async.suggest.BasicSuggestPlainSearcher;
import ru.yandex.msearch.proxy.api.async.suggest.Suggest;
import ru.yandex.msearch.proxy.api.async.suggest.SuggestLuceneRequest;

import ru.yandex.msearch.proxy.api.async.suggest.SuggestRequest;
import ru.yandex.msearch.proxy.api.async.suggest.Suggests;

import ru.yandex.search.result.SearchResult;

public abstract class AbstractPlainSuggestCallback<T extends Suggests<? extends Suggest>>
    extends AbstractFilterFutureCallback<SearchResult, T>
    implements PlainCallback
{
    protected final SuggestLuceneRequest searchRequest;
    protected final SuggestRequest<T> suggestRequest;
    protected final PlainSearcher<SearchResult> searcher;

    public AbstractPlainSuggestCallback(
        final AsyncHttpServer server,
        final SuggestLuceneRequest searchRequest,
        final SuggestRequest<T> suggestRequest)
        throws BadRequestException
    {
        super(suggestRequest.callback());

        this.suggestRequest = suggestRequest;
        this.searchRequest = searchRequest;

        this.searcher =
            new BasicSuggestPlainSearcher(
                server,
                suggestRequest,
                searchRequest.user());
    }

    @Override
    public PlainSearcher<SearchResult> searcher() {
        return searcher;
    }

    public void sendNextRequest() {
        searcher().search(nextRequest(), this);
    }

    @Override
    public Function<? super HttpHost, ? extends HttpAsyncRequestProducer> nextRequest() {
        return new BasicAsyncRequestProducerGenerator(
            searchRequest.luceneRequest());
    }

    protected abstract T empty();
}
