package ru.yandex.msearch.proxy.api.async.suggest.rules;

import org.apache.http.HttpException;

import ru.yandex.msearch.proxy.api.async.suggest.Suggest;
import ru.yandex.msearch.proxy.api.async.suggest.SuggestRequest;
import ru.yandex.msearch.proxy.api.async.suggest.SuggestRule;
import ru.yandex.msearch.proxy.api.async.suggest.Suggests;

import ru.yandex.parser.uri.CgiParams;

public class LastwordSuggestRule <T extends Suggests<? extends Suggest>>
    implements SuggestRule<T>
{
    private SuggestRule<T> next;

    public LastwordSuggestRule(
        final SuggestRule<T> next)
    {
        this.next = next;
    }

    @Override
    public void execute(
        final SuggestRequest<T> sRequest)
        throws HttpException
    {
        CgiParams params = sRequest.cgiParams();
        String request = params.getString("request", "");
        int lastWsIndex =  -1;

        for (int i = 0; i < request.length(); i++) {
            if (Character.isWhitespace(request.charAt(i))
                || Character.isSpaceChar(request.charAt(i)))
            {
                lastWsIndex = i;
            }
        }

        if (!request.isEmpty() && lastWsIndex >= 0) {
            String lastWord =
                request.substring(lastWsIndex + 1, request.length());
            String prefix =
                params.getString("requestPrefix", "")
                    + request.substring(0, lastWsIndex + 1);

            params.replace("request", lastWord);
            params.replace("requestPrefix", prefix);
        }

        next.execute(sRequest.withCgiParams(params));
    }
}
