package ru.yandex.msearch.proxy.api.async.suggest.rules;

import java.util.Locale;

import org.apache.http.HttpException;
import ru.yandex.msearch.proxy.api.async.suggest.BasicSuggestRequestParams;
import ru.yandex.msearch.proxy.api.async.suggest.Suggest;
import ru.yandex.msearch.proxy.api.async.suggest.SuggestRequest;
import ru.yandex.msearch.proxy.api.async.suggest.SuggestRequestParams;
import ru.yandex.msearch.proxy.api.async.suggest.SuggestRule;
import ru.yandex.msearch.proxy.api.async.suggest.Suggests;
import ru.yandex.msearch.proxy.config.ImmutableSubjectSuggestConfig;
import ru.yandex.parser.uri.CgiParams;

/**
 * TokenizeRule for supporting current history-suggest request format
 */
public class LegacyFormatSuggestRule
    implements SuggestRule<Suggests<? extends Suggest>>
{
    private final SuggestRule<Suggests<? extends Suggest>> next;
    private final ImmutableSubjectSuggestConfig suggestConfig;

    public LegacyFormatSuggestRule(
        final ImmutableSubjectSuggestConfig suggestConfig,
        final SuggestRule<Suggests<? extends Suggest>> next)
    {
        this.suggestConfig = suggestConfig;
        this.next = next;
    }

    @Override
    public void execute(
        final SuggestRequest<Suggests<? extends Suggest>> request)
        throws HttpException
    {
        CgiParams params = new CgiParams(request.cgiParams());

        String service = params.getString("service", null);

        String desc = params.getString("desc", "yes").toLowerCase(
            Locale.ENGLISH);

        if (params.getString("order", null) == null) {
            if ("yes".equals(desc) || "true".equals(desc)) {
                params.replace("order", "desc");
            } else {
                params.replace("order", "asc");
            }
        }

        String numdoc = params.getString("numdoc", null);
        if (params.getString("limit", null) == null) {
            params.replace("limit", numdoc);
        }

        String kps = params.getString("kps", null);
        if (params.getString("suid", null) == null) {
            params.replace("suid", kps);
        }

        String format = params.getString("format", null);
        String text = params.getString("text", null);

        if (text != null) {
            // remove legacy garbage around request
            if (text.startsWith("orig_text:\"")) {
                if (text.length() <= 12) {
                    text = "";
                } else {
                    text = text.substring(11, text.length() - 2);
                }
            } else if (text.startsWith("url:\"")) {
                if (text.length() <= 6) {
                    text = "";
                }

                text = text.substring(5, text.length() - 2);
            }

            request.session().logger().info("Replace text with " + text);
        }

        if (params.getString("request", null) == null) {
            params.replace("request", text);
        }

        SuggestRequestParams requestParams =
            new BasicSuggestRequestParams(
                request.requestParams(),
                params,
                true,
                suggestConfig.limit());

        this.next.execute(request.with(params, requestParams));
    }
}
