package ru.yandex.msearch.proxy.api.async.suggest.rules;

import org.apache.http.HttpException;
import ru.yandex.logger.PrefixedLogger;
import ru.yandex.msearch.proxy.AsyncHttpServer;
import ru.yandex.msearch.proxy.api.async.Session;
import ru.yandex.msearch.proxy.api.async.suggest.BasicSuggestLuceneRequest;
import ru.yandex.msearch.proxy.api.async.suggest.Suggest;
import ru.yandex.msearch.proxy.api.async.suggest.SuggestLuceneRequest;
import ru.yandex.msearch.proxy.api.async.suggest.SuggestRequest;
import ru.yandex.msearch.proxy.api.async.suggest.SuggestRule;
import ru.yandex.msearch.proxy.api.async.suggest.Suggests;

public abstract class PlainSuggestRule<T extends Suggests<? extends Suggest>>
    implements SuggestRule<T>
{
    protected final AsyncHttpServer server;

    public PlainSuggestRule(final AsyncHttpServer server) {
        this.server = server;
    }

    public abstract AbstractPlainSuggestCallback<T> createCallback(
        final AsyncHttpServer server,
        final SuggestLuceneRequest searchRequest,
        final SuggestRequest<T> suggestRequest)
        throws HttpException;

    public abstract PrefixedLogger logger(final Session session);

    protected SuggestLuceneRequest buildRequest(
        final SuggestRequest<T> request,
        final PrefixedLogger logger)
        throws HttpException
    {
        return new BasicSuggestLuceneRequest<>(server, request);
    }

    @Override
    public void execute(final SuggestRequest<T> request) throws HttpException {
        SuggestLuceneRequest luceneRequest =
            buildRequest(request, logger(request.session()));

        createCallback(server, luceneRequest, request).sendNextRequest();
    }
}
