package ru.yandex.msearch.proxy.api.async.suggest.rules;

import java.util.LinkedHashSet;
import java.util.Set;

import org.apache.http.HttpException;

import ru.yandex.msearch.proxy.api.async.mail.Side;
import ru.yandex.msearch.proxy.api.async.suggest.Suggest;
import ru.yandex.msearch.proxy.api.async.suggest.SuggestRequest;
import ru.yandex.msearch.proxy.api.async.suggest.SuggestRule;
import ru.yandex.msearch.proxy.api.async.suggest.Suggests;
import ru.yandex.msearch.proxy.api.suggest.Translit;
import ru.yandex.parser.uri.CgiParams;

public class TranslitSuggestRule<T extends Suggests<? extends Suggest>>
    implements SuggestRule<T>
{
    private SuggestRule<T> next;

    public TranslitSuggestRule(
        final SuggestRule<T> next)
    {
        this.next = next;
    }

    @Override
    public void execute(
        final SuggestRequest<T> request)
        throws HttpException
    {
        CgiParams params = new CgiParams(request.cgiParams());
        String requestText = params.getString("request", "");
        Set<String> requestSet = new LinkedHashSet<>();
        Side side = request.requestParams().side();
        requestSet.add(requestText);
        requestSet.addAll(Translit.suggestSet(requestText, side));

        params.remove("request");
        for (String translit : requestSet) {
            params.add("request", translit);
        }

        next.execute(request.withCgiParams(params));
    }
}
