package ru.yandex.msearch.proxy.api.async.suggest.subject;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;

import ru.yandex.json.writer.JsonWriterBase;
import ru.yandex.msearch.proxy.api.async.suggest.BasicSuggest;
import ru.yandex.msearch.proxy.api.async.suggest.Suggest;
import ru.yandex.msearch.proxy.api.async.suggest.united.Target;

public class SubjectSuggest extends BasicSuggest {
    private static final Map<String, String> SUBJECT_PARAM =
        Collections.singletonMap("scope", "hdr_subject_keyword");
    private static final String MAIL_COUNT = "mail-count";
    private final int mailCount;

    public SubjectSuggest(
        final Target target,
        final String showText,
        final String searchText,
        final int mailCount,
        Map<String, String> params)
    {
        super(target, showText, searchText, params);
        this.mailCount = mailCount;
    }

    public SubjectSuggest(
        final Target target,
        final String text,
        final int mailCount)
    {
        super(target, text, text, SUBJECT_PARAM);

        this.mailCount = mailCount;
    }

    @Override
    public Suggest withPrefix(final String prefix) {
        return new SubjectSuggest(
            target,
            showText,
            prefix + searchText,
            mailCount,
            searchParams);
    }

    public int mailCount() {
        return mailCount;
    }

    @Override
    public void appendToWriter(final JsonWriterBase writer)
        throws IOException
    {
        super.appendToWriter(writer);
        writer.key(MAIL_COUNT);
        writer.value(mailCount);
    }
}
