package ru.yandex.msearch.proxy.api.async.suggest.subject;

import java.io.IOException;

import org.apache.http.HttpException;
import org.apache.http.HttpRequest;

import org.apache.http.nio.protocol.BasicAsyncRequestConsumer;
import org.apache.http.nio.protocol.HttpAsyncExchange;
import org.apache.http.nio.protocol.HttpAsyncRequestConsumer;
import org.apache.http.nio.protocol.HttpAsyncRequestHandler;

import org.apache.http.protocol.HttpContext;

import ru.yandex.msearch.proxy.AsyncHttpServer;

import ru.yandex.msearch.proxy.api.async.suggest.BasicSuggestRequest;
import ru.yandex.msearch.proxy.api.async.suggest.BasicSuggestRequestParams;
import ru.yandex.msearch.proxy.api.async.suggest.Suggest;
import ru.yandex.msearch.proxy.api.async.suggest.SuggestPrinter;
import ru.yandex.msearch.proxy.api.async.suggest.SuggestRequest;
import ru.yandex.msearch.proxy.api.async.suggest.SuggestRequestParams;
import ru.yandex.msearch.proxy.api.async.suggest.SuggestRule;
import ru.yandex.msearch.proxy.api.async.suggest.SuggestSession;
import ru.yandex.msearch.proxy.api.async.suggest.Suggests;

import ru.yandex.msearch.proxy.api.async.suggest.rules.LegacyFormatSuggestRule;
import ru.yandex.msearch.proxy.api.async.suggest.rules.ParallelTranslitSuggestRule;
import ru.yandex.msearch.proxy.api.async.suggest.rules.ResolveUserRule;

import ru.yandex.msearch.proxy.api.async.suggest.subject.rules.PlainSubjectSuggestRule;
import ru.yandex.msearch.proxy.api.async.suggest.subject.rules.SubjectRewriteSuggestRule;
import ru.yandex.msearch.proxy.api.async.suggest.subject.rules.SubjectSuggestRule;

import ru.yandex.msearch.proxy.api.async.suggest.united.DefaultSuggestAdapter;
import ru.yandex.msearch.proxy.api.async.suggest.united.SuggestAdapter;
import ru.yandex.msearch.proxy.api.async.suggest.united.Target;

import ru.yandex.msearch.proxy.config.ImmutableSubjectSuggestConfig;
import ru.yandex.msearch.proxy.config.ImmutableSuggestConfig;

public class SubjectSuggestHandler
    implements HttpAsyncRequestHandler<HttpRequest>
{
    public static final String LOG_PREFIX = "subject-suggests";

    private final AsyncHttpServer server;
    private final SuggestRule<Suggests<? extends Suggest>> rule;

    public SubjectSuggestHandler(
        final AsyncHttpServer server)
    {
        this.server = server;

        this.rule = createRule(server);
    }

    public static SuggestAdapter createAdapter(final AsyncHttpServer server) {
        SuggestRule<Suggests<? extends Suggest>> rule = createRule(server);
        return new DefaultSuggestAdapter(server.config(), rule, Target.SUBJECT);
    }

    private static SuggestRule<Suggests<? extends Suggest>> createRule(
        final AsyncHttpServer server)
    {
        ImmutableSuggestConfig config =
            server.config().suggestConfig();
        ImmutableSubjectSuggestConfig suggestConfig =
            config.subjectConfig();

        SuggestRule<Suggests<? extends Suggest>> rule =
            new PlainSubjectSuggestRule(server);

        rule = new SubjectRewriteSuggestRule(suggestConfig, rule);
        rule =
            new ParallelTranslitSuggestRule(
                rule,
                config.translitOriginalMandatory());

        rule = new SubjectSuggestRule(rule, suggestConfig);
        rule = new ResolveUserRule<>(rule, server);
        return new LegacyFormatSuggestRule(suggestConfig, rule);
    }

    @Override
    public HttpAsyncRequestConsumer<HttpRequest> processRequest(
        final HttpRequest httpRequest,
        final HttpContext httpContext)
        throws HttpException, IOException
    {
        return new BasicAsyncRequestConsumer();
    }

    @Override
    public void handle(
        final HttpRequest request,
        final HttpAsyncExchange exchange,
        final HttpContext context)
        throws HttpException, IOException
    {
        SuggestSession session = new SuggestSession(server, exchange, context);

        SuggestRequestParams params =
            new BasicSuggestRequestParams(Target.SUBJECT);

        SuggestPrinter printer = new SuggestPrinter(server, session, params);

        SuggestRequest<Suggests<? extends Suggest>> suggestRequest =
            new BasicSuggestRequest<>(
                session,
                params,
                printer,
                LOG_PREFIX);

        session.logger().info("Execute " + request.toString());
        rule.execute(suggestRequest);
    }
}
