package ru.yandex.msearch.proxy.api.async.suggest.subject.rules;

import java.util.Collection;
import java.util.Collections;
import java.util.Set;

import ru.yandex.dbfields.MailIndexFields;
import ru.yandex.http.util.BadRequestException;
import ru.yandex.msearch.proxy.AsyncHttpServer;

import ru.yandex.msearch.proxy.api.async.mail.Side;

import ru.yandex.msearch.proxy.api.async.suggest.BasicSuggests;
import ru.yandex.msearch.proxy.api.async.suggest.highlight.HighlightedSuggest;

import ru.yandex.msearch.proxy.highlight.HtmlHighlighter;

import ru.yandex.msearch.proxy.api.async.suggest.Suggest;
import ru.yandex.msearch.proxy.api.async.suggest.SuggestLuceneRequest;
import ru.yandex.msearch.proxy.api.async.suggest.SuggestRequest;
import ru.yandex.msearch.proxy.api.async.suggest.Suggests;
import ru.yandex.msearch.proxy.api.async.suggest.lang.SuggestLanguagePack;
import ru.yandex.msearch.proxy.api.async.suggest.rules
    .AbstractPlainSuggestCallback;

import ru.yandex.msearch.proxy.api.async.suggest.subject.SubjectSuggest;
import ru.yandex.msearch.proxy.api.async.suggest.united.Target;

import ru.yandex.search.result.SearchDocument;
import ru.yandex.search.result.SearchResult;

public class PlainSubjectSuggestCallback
    extends AbstractPlainSuggestCallback<Suggests<? extends Suggest>>
{
    private static final Set<Side> QL_SIDES = Collections.emptySet();
        //new HashSet<>(Arrays.asList(Side.TOUCHSM, Side.TOUCHTAB, Side.MOBILE));

    private final boolean highlight;
    private final Collection<String> requests;

    public PlainSubjectSuggestCallback(
        final AsyncHttpServer server,
        final SuggestLuceneRequest searchRequest,
        final SuggestRequest<Suggests<? extends Suggest>> suggestRequest)
        throws BadRequestException
    {
        super(server, searchRequest, suggestRequest);

        this.highlight =
            suggestRequest.cgiParams().getBoolean(
                "highlight",
                server.config().suggestConfig().highlight());
        this.requests =
                suggestRequest.cgiParams().getAll("requestRaw");
    }

    @Override
    public synchronized void completed(final SearchResult searchResult) {
        BasicSuggests suggests =
            new BasicSuggests(
                Target.SUBJECT,
                (int) searchResult.hitsCount());

        for (SearchDocument document: searchResult.hitsArray()) {
            String subject = document.attrs().get(
                SubjectRewriteSuggestRule.SUBJECT_NORMALIZED.name());
            if (subject == null)
            {
                subject = document.attrs().get(
                    SubjectRewriteSuggestRule.SUBJECT.name());
                if (subject == null) {
                    continue;
                }
            }

            String threadId = document.attrs().get(MailIndexFields.THREAD_ID);

            if (threadId == null) {
                continue;
            }

            int threadCount = 1;
            try {
                String countStr = document.attrs().get("merged_docs_count");
                if (countStr != null) {
                    threadCount += Integer.parseInt(countStr);
                }
            } catch (NumberFormatException nfe) {
                failed(nfe);
                return;
            }

            if (!threadId.trim().isEmpty()) {
                String searchText = subject;
                if (QL_SIDES.contains(suggestRequest.requestParams().side())) {
                    searchText =
                        suggestRequest.requestParams().language().ql(
                            SuggestLanguagePack.QL.SUBJECT) + ':';
                    if (subject.trim().split("\\s+").length > 1) {
                        searchText += "(" + subject + ')';
                    } else {
                        searchText += subject;
                    }
                }

                Suggest suggest = new SubjectSuggest(
                    Target.SUBJECT,
                    subject,
                    searchText,
                    threadCount,
                    Collections.singletonMap(
                        "scope",
                        "subject_thread_" + threadId));

                if (highlight) {
                    suggest =
                        new HighlightedSuggest(
                            suggest,
                            HtmlHighlighter.INSTANCE.highlight(
                                requests,
                                subject,
                                true));
                }

                suggests.add(suggest);
            }
        }

        suggestRequest.logger().info(
            "Search completed, size " + suggests.size());

        callback.completed(suggests);
    }

    @Override
    protected BasicSuggests empty() {
        return BasicSuggests.empty(suggestRequest.requestParams().target());
    }
}
