package ru.yandex.msearch.proxy.api.async.suggest.subject.rules;

import ru.yandex.http.util.BadRequestException;
import ru.yandex.logger.PrefixedLogger;

import ru.yandex.msearch.proxy.AsyncHttpServer;

import ru.yandex.msearch.proxy.api.async.Session;
import ru.yandex.msearch.proxy.api.async.suggest.Suggest;
import ru.yandex.msearch.proxy.api.async.suggest.SuggestLuceneRequest;
import ru.yandex.msearch.proxy.api.async.suggest.SuggestRequest;
import ru.yandex.msearch.proxy.api.async.suggest.Suggests;
import ru.yandex.msearch.proxy.api.async.suggest.rules
    .AbstractPlainSuggestCallback;
import ru.yandex.msearch.proxy.api.async.suggest.rules.PlainSuggestRule;

public class PlainSubjectSuggestRule
    extends PlainSuggestRule<Suggests<? extends Suggest>>
{
    private static final String LOG_PREFIX = "suggest-subject-plain";

    private final PrefixedLogger logger;
    public PlainSubjectSuggestRule(final AsyncHttpServer server) {
        super(server);

        this.logger = server.logger().addPrefix(LOG_PREFIX);
    }

    @Override
    public AbstractPlainSuggestCallback<Suggests<? extends Suggest>> createCallback(
        final AsyncHttpServer server,
        final SuggestLuceneRequest searchRequest,
        final SuggestRequest<Suggests<? extends Suggest>> suggestRequest)
        throws BadRequestException
    {
        return new PlainSubjectSuggestCallback(
            server,
            searchRequest,
            suggestRequest);
    }

    @Override
    public PrefixedLogger logger(final Session session) {
        return session.logger().addPrefix("subject-suggest");
    }
}