package ru.yandex.msearch.proxy.api.async.suggest.subject.rules;

import org.apache.http.HttpException;
import ru.yandex.blackbox.BlackboxUserinfo;
import ru.yandex.msearch.proxy.api.async.ProxyParams;
import ru.yandex.msearch.proxy.api.async.suggest.BasicSuggestRequestParams;
import ru.yandex.msearch.proxy.api.async.suggest.Suggest;
import ru.yandex.msearch.proxy.api.async.suggest.SuggestRequest;
import ru.yandex.msearch.proxy.api.async.suggest.SuggestRequestParams;
import ru.yandex.msearch.proxy.api.async.suggest.SuggestRule;
import ru.yandex.msearch.proxy.api.async.suggest.Suggests;
import ru.yandex.msearch.proxy.config.ImmutableSubjectSuggestConfig;
import ru.yandex.parser.uri.CgiParams;

public class SubjectSuggestRule
    implements SuggestRule<Suggests<? extends Suggest>>
{
    private static final String MESSAGE_TYPE_GROUP = "mtype_group";
    private static final String MESSAGE_TYPES_PREFIX = "mtypes";
    // message_types to have low range by default
    private static final String DEFAULT_LOW_MTYPES = "people";
    private static final String DEFAULT_ORDER = "desc,desc";
    private static final String DEFAULT_SORT_FIELDS =
        "mtype_group_low,received_date";


    private final SuggestRule<Suggests<? extends Suggest>> next;
    private final ImmutableSubjectSuggestConfig suggestConfig;

    public SubjectSuggestRule(
        final SuggestRule<Suggests<? extends Suggest>> next,
        final ImmutableSubjectSuggestConfig suggestConfig)
    {
        this.next = next;
        this.suggestConfig = suggestConfig;
    }

    @Override
    public void execute(
        final SuggestRequest<Suggests<? extends Suggest>> request)
        throws HttpException
    {
        CgiParams params = new CgiParams(request.cgiParams());
        String sort_fields = params.getString("sort_fields", null);
        if (sort_fields == null) {
            params.replace("sort_fields", DEFAULT_SORT_FIELDS);
            params.replace("order", DEFAULT_ORDER);
            params.replace("mtypes_low", DEFAULT_LOW_MTYPES);
        }

        SuggestRequestParams requestParams =
            new BasicSuggestRequestParams(
                request.requestParams(),
                params,
                true,
                suggestConfig.limit());

        params.remove("dp");
        for (String field: requestParams.fields()) {
            if (field.startsWith(MESSAGE_TYPE_GROUP)) {
                String name = field.substring(MESSAGE_TYPE_GROUP.length());
                String messageTypes = params.getString(
                    MESSAGE_TYPES_PREFIX + name);

                StringBuilder sb = new StringBuilder(
                    "contains_any(message_type,");
                sb.append(messageTypes);
                sb.append(" ");
                sb.append(field);
                sb.append(")");
                params.add("dp", sb.toString());
            }
        }

        this.next.execute(request.with(params, requestParams));
    }

}
