package ru.yandex.msearch.proxy.api.async.suggest.united;

import org.apache.http.HttpException;
import org.apache.http.concurrent.FutureCallback;

import ru.yandex.msearch.proxy.api.async.suggest.BasicSuggestRequest;
import ru.yandex.msearch.proxy.api.async.suggest.BasicSuggestRequestParams;
import ru.yandex.msearch.proxy.api.async.suggest.Suggest;
import ru.yandex.msearch.proxy.api.async.suggest.SuggestRequest;
import ru.yandex.msearch.proxy.api.async.suggest.SuggestRequestParams;
import ru.yandex.msearch.proxy.api.async.suggest.SuggestRule;
import ru.yandex.msearch.proxy.api.async.suggest.Suggests;

import ru.yandex.msearch.proxy.config.ImmutableMsearchProxyConfig;

import ru.yandex.parser.uri.CgiParams;

import ru.yandex.stater.RequestsStater;

public class DefaultSuggestAdapter implements SuggestAdapter {
    public static final String URI_PREFIX = "/api/async/mail/suggest/";

    private final SuggestRule<Suggests<? extends Suggest>>  next;
    private final Target target;
    private final String prefix;
    protected final RequestsStater stater;

    public DefaultSuggestAdapter(
        final ImmutableMsearchProxyConfig config,
        final SuggestRule<Suggests<? extends Suggest>> next,
        final Target target)
    {
        this.next = next;
        this.target = target;
        this.prefix = target + "-suggest";
        this.stater = null;
    }

    protected AdapterCallback<Suggests<? extends Suggest>> callback(
        final SuggestRequest<UnitedSuggests> request,
        final FutureCallback<Suggests<? extends Suggest>> callback)
    {
        return new AdapterCallback<>(callback, stater);
    }

    @Override
    public void execute(
        final SuggestRequest<UnitedSuggests> request,
        final CgiParams params,
        final FutureCallback<Suggests<? extends Suggest>> callback)
        throws HttpException
    {
        SuggestRequestParams requestParams =
            new BasicSuggestRequestParams(
                target,
                request.cgiParams(),
                request.requestParams().experiments(),
                request.requestParams().length());

        AdapterCallback<Suggests<? extends Suggest>> adapterCallback =
            callback(request, callback);

        SuggestRequest<Suggests<? extends Suggest>> targetRequest =
            new BasicSuggestRequest<Suggests<? extends Suggest>>(
                request.session(),
                request.cgiParams(),
                requestParams,
                adapterCallback,
                prefix);

        adapterCallback.logger(targetRequest.logger());

        targetRequest.logger().info("Executing suggest");
        this.next.execute(targetRequest);
    }

    @Override
    public void execute(
        final SuggestRequest<UnitedSuggests> request,
        final FutureCallback<Suggests<? extends Suggest>> callback)
        throws HttpException
    {
        this.execute(request, request.cgiParams(), callback);
    }

    @Override
    public Target target() {
        return target;
    }
}
