package ru.yandex.msearch.proxy.api.async.suggest.united;

import org.apache.http.HttpException;
import org.apache.http.concurrent.FutureCallback;
import ru.yandex.msearch.proxy.api.async.suggest.Suggest;
import ru.yandex.msearch.proxy.api.async.suggest.SuggestRequest;
import ru.yandex.msearch.proxy.api.async.suggest.Suggests;
import ru.yandex.parser.uri.CgiParams;

public interface SuggestAdapter {
    void execute(
        final SuggestRequest<UnitedSuggests> request,
        final CgiParams params,
        final FutureCallback<Suggests<? extends Suggest>> callback)
        throws HttpException;

    default void execute(
        final SuggestRequest<UnitedSuggests> request,
        final FutureCallback<Suggests<? extends Suggest>> callback)
        throws HttpException
    {
        this.execute(request, request.cgiParams(), callback);
    }

    Target target();
}
