package ru.yandex.msearch.proxy.api.async.suggest.united;

import java.io.IOException;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;

import org.apache.http.Header;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;

import org.apache.http.concurrent.FutureCallback;
import org.apache.http.nio.protocol.BasicAsyncRequestConsumer;
import org.apache.http.nio.protocol.HttpAsyncExchange;
import org.apache.http.nio.protocol.HttpAsyncRequestConsumer;
import org.apache.http.nio.protocol.HttpAsyncRequestHandler;

import org.apache.http.protocol.HttpContext;

import ru.yandex.http.util.YandexHeaders;
import ru.yandex.msearch.proxy.AsyncHttpServer;

import ru.yandex.msearch.proxy.api.async.mail.ExperimentsFlagsParser;
import ru.yandex.msearch.proxy.api.async.suggest.BasicSuggestRequest;
import ru.yandex.msearch.proxy.api.async.suggest.BasicSuggestRequestParams;

import ru.yandex.msearch.proxy.api.async.suggest.SuggestRequest;
import ru.yandex.msearch.proxy.api.async.suggest.SuggestRequestParams;
import ru.yandex.msearch.proxy.api.async.suggest.SuggestRule;
import ru.yandex.msearch.proxy.api.async.suggest.SuggestSession;

import ru.yandex.msearch.proxy.api.async.suggest.SuggestWeights;
import ru.yandex.msearch.proxy.api.async.suggest.contact.ContactSuggestHandler;

import ru.yandex.msearch.proxy.api.async.suggest.folder.FolderSuggestHandler;

import ru.yandex.msearch.proxy.api.async.suggest.history.HistorySuggestHandler;

import ru.yandex.msearch.proxy.api.async.suggest.label.LabelSuggestHandler;

import ru.yandex.msearch.proxy.api.async.suggest.mail.MailSuggestAdapter;
import ru.yandex.msearch.proxy.api.async.suggest.mtype.CategorySuggestRule;
import ru.yandex.msearch.proxy.api.async.suggest.ql.QueryLanguageSuggestRule;
import ru.yandex.msearch.proxy.api.async.suggest.rules.LastwordSuggestRule;
import ru.yandex.msearch.proxy.api.async.suggest.rules.ResolveUserRule;

import ru.yandex.msearch.proxy.api.async.suggest.subject.SubjectSuggestHandler;

import ru.yandex.msearch.proxy.api.async.suggest.united.rules
    .AggregateSuggestRule;

import ru.yandex.msearch.proxy.api.async.suggest.united.rules.FilterSuggestRule;
import ru.yandex.msearch.proxy.api.async.suggest.united.rules.TimeoutSuggestRule;
import ru.yandex.msearch.proxy.config.ImmutableSuggestConfig;
import ru.yandex.msearch.proxy.experiment.MalformedUserSplitException;
import ru.yandex.msearch.proxy.experiment.UserSplit;

public class UnitedSuggestHandler
    implements HttpAsyncRequestHandler<HttpRequest>
{
    private final AsyncHttpServer server;
    private final SuggestRule<UnitedSuggests> rule;
    private final ImmutableSuggestConfig suggestConfig;

    public UnitedSuggestHandler(final AsyncHttpServer server) {
        this.server = server;
        this.suggestConfig = server.config().suggestConfig();

        List<SuggestAdapter> adapters = new ArrayList<>();

        adapters.add(ContactSuggestHandler.createAdapter(server));
        adapters.add(SubjectSuggestHandler.createAdapter(server));
        adapters.add(HistorySuggestHandler.createAdapter(server));
        adapters.add(FolderSuggestHandler.createAdapter(server));
        adapters.add(LabelSuggestHandler.createAdapter(server));
        adapters.add(
            new DefaultSuggestAdapter(
                server.config(),
                new LastwordSuggestRule<>(new CategorySuggestRule(server)),
                Target.CATEGORY));
        adapters.add(
            new DefaultSuggestAdapter(
                server.config(),
                new LastwordSuggestRule<>(
                    new QueryLanguageSuggestRule(
                        server.config().suggestConfig())),
                Target.QL));
        adapters.add(new MailSuggestAdapter(server));

        SuggestRule<UnitedSuggests> rule =
            new AggregateSuggestRule(
                server.config().suggestConfig(),
                adapters);

        rule = new FilterSuggestRule(rule);
        rule = new ResolveUserRule<>(rule, server);
        this.rule = new TimeoutSuggestRule(server, rule);
    }

    @Override
    public HttpAsyncRequestConsumer<HttpRequest> processRequest(
        final HttpRequest httpRequest,
        final HttpContext httpContext)
        throws HttpException, IOException
    {
        return new BasicAsyncRequestConsumer();
    }

    public void handle(
        final SuggestSession session,
        final FutureCallback<UnitedSuggests> printer)
        throws HttpException, IOException
    {
        Header enabledBoxed =
            session.request().getFirstHeader(YandexHeaders.X_ENABLED_BOXES);

        String experimentsString = null;
        if (enabledBoxed != null) {
            experimentsString = enabledBoxed.getValue();
        }

        ExperimentsFlagsParser.apply(session, session.params());

        SuggestRequestParams params =
            new BasicSuggestRequestParams(
                Target.UNITED,
                session.params(),
                experimentsString,
                -1,
                false,
                suggestConfig.limit());

        SuggestRequest<UnitedSuggests> suggestRequest =
            new BasicSuggestRequest<>(
                session,
                params,
                printer);

        rule.execute(suggestRequest);
    }

    @Override
    public void handle(
        final HttpRequest request,
        final HttpAsyncExchange exchange,
        final HttpContext context)
        throws HttpException, IOException
    {
        SuggestSession session = new SuggestSession(server, exchange, context);

        UnitedSuggestPrinter printer = new UnitedSuggestPrinter(session);

        handle(session, printer);
    }
}
