package ru.yandex.msearch.proxy.api.async.suggest.united;

import java.io.IOException;

import ru.yandex.http.util.BadRequestException;

import ru.yandex.json.writer.JsonWriter;

import ru.yandex.msearch.proxy.api.async.suggest.BasicSuggestPrinter;
import ru.yandex.msearch.proxy.api.async.suggest.Suggest;
import ru.yandex.msearch.proxy.api.async.suggest.SuggestSession;

import ru.yandex.tskv.TskvString;

public class UnitedSuggestPrinter extends BasicSuggestPrinter<UnitedSuggests> {
    public UnitedSuggestPrinter(final SuggestSession session)
        throws BadRequestException
    {
        super(session.server(), session);
    }

    @Override
    protected void writeSuggests(
        final UnitedSuggests suggests,
        final JsonWriter writer)
        throws IOException
    {
        writer.startArray();
        for (Suggest s: suggests) {
            writer.value(s);
        }

        writer.endArray();

        if (suggests.status() > 0) {
            session.getResponse()
                .addHeader("Status", String.valueOf(suggests.status()));
        }

        session.logger().info("Status " + suggests.status());
    }

    @Override
    protected void writeDetails() {
    }

    @Override
    protected TskvString logRequest(
        final UnitedSuggests suggests)
    {
        TskvString message = super.logRequest(suggests);
        if (message != null) {
            message.append("status", suggests.status());
        }

        return message;
    }
}