package ru.yandex.msearch.proxy.api.chemodan;

import javax.crypto.spec.IvParameterSpec;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;

import java.net.URLEncoder;

import org.apache.http.HttpException;
import org.apache.http.HttpStatus;
import ru.yandex.http.util.BadRequestException;
import ru.yandex.http.util.ServerException;
import ru.yandex.msearch.proxy.api.ApiException;
import ru.yandex.msearch.proxy.api.async.mail.chemodan.AttachShield;

public class AttachShieldOld implements AttachShield {
    private String iv =
        System.getenv().getOrDefault("ATTACHSHIELD_IV", "Anything")
            .substring(0, 8);
    private String key =
        System.getenv().getOrDefault("ATTACHSHIELD_KEY", "AttachShieldKey!")
            .substring(0, 16);
    private Cipher cipher;
    private int timeout;
    private final static char delimiter = ':';

    public AttachShieldOld(int timeout) throws HttpException {
        this.timeout = timeout;
        try {
            SecretKeySpec skey = new SecretKeySpec(key.getBytes(), "Blowfish");
            cipher = Cipher.getInstance("Blowfish/CBC/PKCS5Padding");
            cipher.init(
                Cipher.ENCRYPT_MODE,
                skey,
                new IvParameterSpec(iv.getBytes()));
        } catch (Exception e) {
            throw new ServerException(HttpStatus.SC_INTERNAL_SERVER_ERROR,
                "Can't initialize attachshield: " + e.getMessage(), e);
        }
    }

    @Override
    public String encode(String stid, String hid, String mid, final long uid)
        throws HttpException
    {
        try {
            return URLEncoder.encode(
                encodeChars4Opera(
                    encodeBase64(
                        encryptString(
                            "single_message_part:{\"ts\":"
                                + (System.currentTimeMillis() / 1000 + timeout)
                                + ",\"uid\":\"" + uid + "\",\"mid\":\"" + mid
                                + "\",\"hid\":\"" + hid + "\"}"))));
        } catch (Exception e) {
            throw new BadRequestException("Failed to encode attach sid", e);
        }
    }

    private byte[] encryptString(String in) throws ApiException {
        try {
            return cipher.doFinal(in.getBytes());
        } catch (Exception e) {
            throw new ApiException(
                "AttachShield encryptError: " + e.getMessage());
        }
    }

    private String encodeBase64(byte[] in)
    {
        return Base64.encode(in);
    }

    private String encodeChars4Opera(String in)
    {
        return in.replace('+', '*');
    }
}
