package ru.yandex.msearch.proxy.api.chemodan;

import java.util.HashMap;
import java.util.Map;

public enum Attr {
    CTIME("ctime", "received_date"),
    NAME("name", "attachname"),
    ST_ID("st_id", "stid"),
    TYPE("type", "mimetype"),
    SIZE("size", "attachsize_b"),
    ID("id", "url");

    private static final Map<String, Attr> diskNames = new HashMap<>();
    private static final Map<String, Attr> luceneNames = new HashMap<>();

    static {
        for (Attr attr: values()) {
            diskNames.put(attr.diskName(), attr);
            luceneNames.put(attr.luceneName(), attr);
        }
    }

    private final String diskName;
    private final String luceneName;

    Attr(final String diskName, final String luceneName) {
        this.diskName = diskName;
        this.luceneName = luceneName;
    }

    public String diskName() {
        return diskName;
    }

    public String luceneName() {
        return luceneName;
    }

    public static Attr resolveDiskName(final String diskName) {
        return diskNames.get(diskName);
    }

    public static Attr resolveLuceneName(final String luceneName) {
        return luceneNames.get(luceneName);
    }
}

