package ru.yandex.msearch.proxy.api.chemodan;

import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

import java.net.URL;
import java.net.URLConnection;

import java.io.PrintStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.IOException;

import org.json.*;

import ru.yandex.msearch.proxy.document.Document;

public class ChemodanDocument extends Document
{
    private static final Set<String> INT_FIELDS =
        new HashSet<>(Arrays.asList("ctime", "size"));
    private static final Comparator<String> ID_COMPARATOR =
        Comparator.nullsFirst(Comparator.naturalOrder());

    protected final Map<String,String> metaAttrs = new HashMap<>();
    private boolean folder;
    private boolean system;
    private boolean currentFolder;
    private int fileCount;
    private boolean remove = false;

    public ChemodanDocument(final boolean isFolder) {
        this(isFolder, INT_FIELDS);
    }

    public ChemodanDocument( boolean isFolder, Set<String> intFields )
    {
	super( intFields );
	folder = isFolder;
	fileCount = 0;
	currentFolder = false;
	system = false;
    }

    public void setRemove( boolean r )
    {
	remove = r;
    }

    public void setMetaAttr( String key, String value )
    {
	metaAttrs.put(key, value);
    }
    
    public void setMetaAttrs( ChemodanDocument other )
    {
	metaAttrs.putAll(other.metaAttrs);
    }
    
    public void setMetaAttrs( Document other )
    {
	metaAttrs.putAll(other.getAttrs());
    }
    
    public String getMetaAttr( String key )
    {
	return metaAttrs.get(key);
    }
    
    public Map<String,String> getMetaAttrs()
    {
	return metaAttrs;
    }

    @Override
    public void setOrderField( String field )
    {
        super.setOrderField( field );
	if( orderField != null ) orderField = orderField.toLowerCase();
    }

    public final void setCurrentFolder( boolean s )
    {
	currentFolder = s;
    }

    public final boolean isCurrentFolder()
    {
	return currentFolder;
    }

    public final boolean isFolder()
    {
	return folder;
    }

    public final boolean isSystem()
    {
	return system;
    }

    public final void setSystem( boolean s )
    {
	system = s;
    }

    public final String id()
    {
	return getAttr("id");
    }

    public final String parentId()
    {
	return getMetaAttr("parentId");
    }

    public final void incCount()
    {
	fileCount++;
    }

    public final void incCount( int amount )
    {
	fileCount += amount;
    }

    public final int getCount()
    {
	return fileCount;
    }

    @Override
    public boolean equals( Object o )
    {
//	ChemodanDocument other = (ChemodanDocument)o;
//	if( groupField == null ) return false;
//	if( other.groupField == null ) return false;
//	return groupField.equals(other.groupField);
	if( remove && o == this ) return true;
	return false;
    }

    @Override
    protected int doCompareTo(final Document other) {
        int cmp = super.doCompareTo(other);
        if (cmp == 0) {
            cmp = ID_COMPARATOR.compare(id(), ((ChemodanDocument) other).id());
        }
        return cmp;
    }

    public final int compareFolders( ChemodanDocument other )
    {
	if( other.isSystem() && !this.isSystem() ) return 1;
	else if( !other.isSystem() && this.isSystem() ) return -1;

        return super.compareTo(other);
    }

    @Override
    public int compareTo( Document o )
    {
	ChemodanDocument other = (ChemodanDocument)o;
	if( other.isFolder() && this.isFolder() ) return compareFolders( other );

        return super.compareTo(other);
    }
}
