package ru.yandex.msearch.proxy.api.chemodan;

import java.util.Iterator;
import java.util.TreeMap;
import java.util.Map;
import java.util.Arrays;
import java.io.PrintStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.io.IOException;
import org.json.JSONWriter;
import java.net.URLEncoder;
import com.tecnick.htmlutils.htmlentities.HTMLEntities;
import org.apache.commons.lang3.StringEscapeUtils;

import ru.yandex.msearch.proxy.logger.Logger;
import ru.yandex.msearch.proxy.document.Document;
import ru.yandex.msearch.proxy.collector.Collector;
import ru.yandex.msearch.proxy.HttpServer.RequestContext;
import org.apache.commons.lang3.text.translate.AggregateTranslator;
import org.apache.commons.lang3.text.translate.CharSequenceTranslator;
import org.apache.commons.lang3.text.translate.EntityArrays;
import org.apache.commons.lang3.text.translate.LookupTranslator;
import org.apache.commons.lang3.text.translate.CodePointTranslator;

public class ChemodanPrinter
{
Map<String,String> params;
String sessionId;
RequestContext ctx;
private static final LookupTranslator BASIC_ESCAPE = new LookupTranslator(EntityArrays.BASIC_ESCAPE());
private static final LookupTranslator APOS_ESCAPE = new LookupTranslator(EntityArrays.APOS_ESCAPE());
private static final LookupTranslator CTRL_ESCAPE = new LookupTranslator(new String[][]{
    {"\n", "&#10;"},
    {"\r", "&#13;"},
    {"\t", "&#9;"}
});
private CharSequenceTranslator xmlEscaper;
private NonVisibleCharsTranslator badCharsEscaper;
private StringWriter stringWriter;

    private class NonVisibleCharsTranslator extends CodePointTranslator
    {
    private boolean hasInvalidChars = false;

	public boolean hasInvalidChars()
	{
	    return this.hasInvalidChars;
	}

	public void resetHasInvalidChars()
	{
	    this.hasInvalidChars = false;
	}

	public boolean translate(int codepoint, Writer out) throws IOException
	{
            if (codepoint < ' ') {
                hasInvalidChars = true;
                out.write(' ');
                return true;
            } else {
                return false;
            }
	}
    }

    public ChemodanPrinter( RequestContext ctx )
    {
	this.ctx = ctx;
	createEscaper();
    }

    private void createEscaper()
    {
	badCharsEscaper = new NonVisibleCharsTranslator();
	xmlEscaper = new AggregateTranslator( BASIC_ESCAPE, APOS_ESCAPE, CTRL_ESCAPE, badCharsEscaper );
	stringWriter = new StringWriter( 1024 );
    }
    
    public int print( ChemodanCollector collector, PrintStream ps, int offset, int length )
    {
	return printXml( ps, collector, offset, length );
//	return 0;
    }
    
    private int printXml( PrintStream ps, ChemodanCollector collector, int offset, int length )
    {
	ctx.setContentType( "text/xml" );
	ps.print( "<resources count=\"" + collector.getTotalCount() + "\">" );
	ChemodanDocument currentFolder;

	Map<ChemodanDocument,ChemodanDocument> hits = collector.hits();
	Iterator<ChemodanDocument> iter = hits.keySet().iterator();

	
	currentFolder = collector.getCurrentFolder();
	if( currentFolder != null )
	{
	    currentFolder.setMetaAttr( "CurrentFolder", "1" );
	    startFolder( ps, currentFolder );
	}
//	ps.println( "<details crc32=\"123\" my_email=\"0\" page_number=\"" + (offset / perPage) + 1 + "\" request=\"\" tz=\"Europe/Moscow\"/>" );
	int i = 0;
	while( iter.hasNext() )
	{
	    ChemodanDocument doc = iter.next();
	    if( i++ < offset ) continue;
	    if( i > length + offset ) break;
//	    ctx.log.debug( "printing <" + i + "> doc: " + doc.id() );
	    if( doc.isFolder() )
	    {
		startFolder( ps, doc );
		endFolder( ps );
	    }
	    else
	    {
		startFile( ps, doc );
		endFile( ps );
	    }
	    if( ps.checkError() )
	    {
		ctx.log.err( "error writing out chemodan xml: output stream is closed." );
		break;
	    }
	}
	if( currentFolder != null )
	{
	    endFolder( ps );
	}
	ps.print( "</resources>" );
	
	return i - offset;
    }
    
    private void startFolder( PrintStream ps, ChemodanDocument doc )
    {
        ps.print( "<folder" );
        Map<String,String> attrs = doc.getAttrs();
        Iterator<Map.Entry<String,String>> attrIter = attrs.entrySet().iterator();
        while( attrIter.hasNext() )
        {
	    Map.Entry<String,String> entry = attrIter.next();
	    ps.print( " " );
	    ps.print( entry.getKey() );
	    ps.print( "=\"" );
	    encodeAndPrint( ps, entry.getValue() );
	    ps.print( "\"" );
	}
	ps.print( ">" );

	ps.print( "<metainfo>" );
	
	printMeta( ps, "filecount", Integer.toString(doc.getCount()) );
        attrs = doc.getMetaAttrs();
        attrIter = attrs.entrySet().iterator();
        while( attrIter.hasNext() )
        {
	    Map.Entry<String,String> entry = attrIter.next();
	    printMeta( ps, entry.getKey(), entry.getValue() );
	}
	ps.print( "</metainfo>" );
    }

    private void printMeta( PrintStream ps, String key, String value )
    {
	ps.print( "<meta name=\"" );
	ps.print( key );
	ps.print( "\" value=\"" );
	encodeAndPrint( ps, value );
	ps.print( "\"/>" );
    }

    private void endFolder( PrintStream ps )
    {
        ps.print( "</folder>" );
    }

    private void startFile( PrintStream ps, ChemodanDocument doc )
    {
        ps.print( "<file" );
        Map<String,String> attrs = doc.getAttrs();
        Iterator<Map.Entry<String,String>> attrIter = attrs.entrySet().iterator();
        while( attrIter.hasNext() )
        {
	    Map.Entry<String,String> entry = attrIter.next();
	    ps.print( " " );
	    ps.print( entry.getKey() );
	    ps.print( "=\"" );
	    encodeAndPrint( ps, entry.getValue() );
	    ps.print( "\"" );
	}
	ps.print( ">" );
	ps.print( "<metainfo>" );

        attrs = doc.getMetaAttrs();
        attrIter = attrs.entrySet().iterator();
        while( attrIter.hasNext() )
        {
	    Map.Entry<String,String> entry = attrIter.next();
	    ps.print( "<meta name=\"" );
	    ps.print( entry.getKey() );
	    ps.print( "\" value=\"" );
	    encodeAndPrint( ps, entry.getValue() );
	    ps.print( "\"/>" );
	}
	ps.print( "</metainfo>" );
    }
    
    private void endFile( PrintStream ps )
    {
        ps.print( "</file>" );
    }

    private final void encodeAndPrint( PrintStream ps, String in )
    {
	try
	{
	    xmlEscaper.translate( in, stringWriter );
	}
	catch( IOException ign )
	{
	    //this should never happen with stringWriter
	}
	ps.print( stringWriter.toString() );
	stringWriter.getBuffer().setLength( 0 );
	if( badCharsEscaper.hasInvalidChars() )
	{
	    ctx.log.err( "ChemodanOutput: Invalid characters detected in output string: " + in );
	    badCharsEscaper.resetHasInvalidChars();
	}
    }

    private final String encode( String in )
    {
	try
	{
	    xmlEscaper.translate( in, stringWriter );
	}
	catch( IOException ign )
	{
	    //this should never happen with stringWriter
	}
	String out = stringWriter.toString();
	stringWriter.getBuffer().setLength( 0 );
	return out;
    }
}

