package ru.yandex.msearch.proxy.api.chemodan;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.net.URL;
import java.net.URLConnection;
import java.io.PrintStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.IOException;
import org.json.*;

import ru.yandex.msearch.proxy.api.ApiException;
import ru.yandex.msearch.proxy.document.Document;
import ru.yandex.msearch.proxy.logger.Logger;

public class MailWrappingChemodanDocument extends ChemodanDocument
{
private boolean converted;
private Document doc;
private Document parent;
private ChemodanDocument folder;
private String id;
private String name;
private String mid;
private String hid;
private String ctime;
private String size;
private String type;
private ChemodanMailSearcher searcher;

    public MailWrappingChemodanDocument( ChemodanMailSearcher searcher, Document doc, Document parent, ChemodanDocument folder )
    {
	super(false);
	this.doc = doc;
	this.parent = parent;
	this.searcher = searcher;
	this.folder = folder;
	converted = false;
    }

    public Document getMailDocument()
    {
	if( parent != null ) return parent;
	return doc;
    }

    public Document getOrigDocument()
    {
	return doc;
    }

    public void setAttr( String key, String value )
    {
	checkConverted();
	attrs.put(key, value);
    }
    
    public void setAttrs( Document other )
    {
	checkConverted();
	super.setAttrs(other);
    }
    
    public String getAttr( String key )
    {
	checkConverted();
	return attrs.get(key);
    }
    
    public Map<String,String> getAttrs()
    {
	checkConverted();
	return attrs;
    }


    public final void setMetaAttr( String key, String value )
    {
	checkConverted();
	metaAttrs.put(key, value);
    }
    
    public final void setMetaAttrs( ChemodanDocument other )
    {
	checkConverted();
	metaAttrs.putAll(other.metaAttrs);
    }
    
    public final void setMetaAttrs( Document other )
    {
	checkConverted();
	metaAttrs.putAll(other.getAttrs());
    }
    
    public final String getMetaAttr( String key )
    {
	checkConverted();
	return metaAttrs.get(key);
    }
    
    public final Map<String,String> getMetaAttrs()
    {
	checkConverted();
	return metaAttrs;
    }

    private final String getHid( Document doc )
    {
	String url = doc.getAttr("url");
	int slashPos = url.indexOf('/');
	if( slashPos == -1 || slashPos >= url.length() ) return "0";
	return url.substring( slashPos + 1 );
    }

    private final void convert()
    {
	converted = true;
//	Logger.info( "Convert: " + doc.getAttr("mid") );
//	Logger.info( "Convert" );
        if( ctime == null && parent != null ) ctime = parent.getAttr("received_date");
	if( ctime == null ) ctime = doc.getAttr("received_date");
	attrs.put( "ctime", ctime );
	attrs.put( "source", "mail" );
	if( parent != null ) metaAttrs.putAll( parent.getAttrs() );
	metaAttrs.putAll( doc.getAttrs() );
	if( mid == null ) mid = doc.getAttr("mid");
	if( hid == null ) hid = getHid( doc );
	if( id == null ) id = ChemodanMailSearcher.encodeFileId( mid + "/" + hid );
	if( name == null ) name = doc.getAttr("attachname");
	if( size == null ) size = String.valueOf(Integer.parseInt(doc.getAttr("attachsize_b")));
	if( type == null ) type = doc.getAttr("mimetype");

	if( folder != null )
	{
	    metaAttrs.put( "fullpath", folder.getMetaAttr("fullpath") + "/" + id );
	    metaAttrs.put( "fullname", folder.getMetaAttr("fullname") + "/" + name );
	}

	String stid;
	if( parent != null ) stid = parent.getAttr("st_id");
	else stid = doc.getAttr("st_id");
	if( stid == null )
	{
	    Logger.err( "Document <" + mid + "> contains no st_id" );
	    stid = "1.2.3";
	}
	if( stid.startsWith("mulca:2:") ) stid = stid.substring( 8 );
	
	attrs.put( "id", id );
	attrs.put( "name", name );
	attrs.put( "size", size );
	attrs.put( "type", type );
	String url;
	try
	{
	    url = searcher.makeUrl(
                name,
                Long.parseLong(searcher.userInfo().getUid()),
                stid,
                hid,
                mid);
	}
	catch( ApiException | NumberFormatException e )
	{
	    url = "";
	}
	metaAttrs.put( "url", url );
	metaAttrs.put( "hid", hid );
	metaAttrs.put( "stid", stid );
	metaAttrs.put( "part", hid );
	if( ChemodanMailSearcher.previewableFile(this) )
	{
	    metaAttrs.put( "preview", url + "&thumb=y" );
	}
    }

    private final void checkConverted()
    {
	if( !converted ) convert();
    }

    @Override
    public void setOrderField( String field )
    {
	if( field.equals("name") )
	{
	    if( name == null )
            {
                name = doc.getAttr("attachname");
                attrs.put( "name", name );
            }
	}
	else if( field.equals("id") )
	{
	    if( mid == null ) mid = doc.getAttr("mid");
	    if( hid == null ) hid = getHid( doc );
	    if( id == null )
            {
                id = ChemodanMailSearcher.encodeFileId( mid + "/" + hid );
                attrs.put( "id", id );
            }
	}
	else if( field.equals("size") )
	{
            size = String.valueOf(Integer.parseInt(doc.getAttr("attachsize_b")));
            attrs.put( "size", size );
	}
	else if( field.equals("type") )
	{
	    type = doc.getAttr("mimetype");
            attrs.put( "type", type );
	}
	else if( field.equals("ctime") )
	{
            if( ctime == null)
            {
                if( parent == null )
                {
                    ctime = doc.getAttr("received_date");
                }
                else
                {
                    ctime = parent.getAttr("received_date");
                }
                attrs.put( "ctime", ctime );
            }
	}
        super.setOrderField( field );
    }

}
