package ru.yandex.msearch.proxy.api.chemodan;

import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;

import ru.yandex.msearch.proxy.document.Document;

public class SortingCollector implements ChemodanCollector
{

private int totalCount = 0;
private TreeMap<ChemodanDocument,ChemodanDocument> docs;
private DocComparator comparator;
private Attr sortAttr;
private boolean ascending;
private boolean root = true;
private ChemodanDocument currentFolder = null;
private int maxEntries;

    public SortingCollector(
        final Attr sortAttr,
        final boolean ascending,
        final int maxEntries)
    {
	this.sortAttr = sortAttr;
	this.ascending = ascending;
	this.maxEntries = maxEntries;
	comparator = new DocComparator();
	docs = new TreeMap<>(comparator);
    }

    @Override
    public synchronized void incTotalCount( int inc )
    {
	totalCount += inc;
    }

    @Override
    public int getTotalCount()
    {
	return totalCount;
    }

    @Override
    public int getCount()
    {
	return docs.keySet().size();
    }

    @Override
    public Map<ChemodanDocument,ChemodanDocument> hits()
    {
	return docs;
    }

    public synchronized void collect( ChemodanDocument doc )
    {
	if( doc == null ) return;
	doc.setOrderField(sortAttr.diskName());
	docs.put( doc, doc );
	incTotalCount( 1 );
	if( docs.size() > maxEntries ) docs.remove( docs.lastKey() );
    }

    public void setCurrentFolder( ChemodanDocument doc )
    {
	currentFolder = doc;
    }

    public ChemodanDocument getCurrentFolder()
    {
	return currentFolder;
    }

    @SuppressWarnings("unchecked")
    private class DocComparator implements Comparator<ChemodanDocument>
    {
	public DocComparator() {
	}

        @Override
        public int compare(ChemodanDocument a, ChemodanDocument b) {
	    if (a.equals(b)) {
	        return 0;
	    }

	    //folders are allways on top
	    if (a.isFolder() && !b.isFolder()) {
	        return -1;
	    } else if (b.isFolder() && !a.isFolder()) {
	        return 1;
	    }

	    if (ascending) {
	        return a.compareTo(b);
	    } else {
	        return b.compareTo(a);
	    }
	}
    }
}

