package ru.yandex.msearch.proxy.api.chemodan;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.InputStream;
import java.io.BufferedReader;

import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;

import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.apache.http.client.*;
import org.apache.http.impl.client.*;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpGet;

import ru.yandex.client.tvm2.Tvm2TicketRenewalTask;
import ru.yandex.http.util.YandexHeaders;
import ru.yandex.http.util.client.measurable.MeasurableHttpContext;
import ru.yandex.msearch.proxy.MsearchProxyException;
import ru.yandex.msearch.proxy.api.ApiException;
import ru.yandex.msearch.proxy.config.ImmutableMsearchProxyConfig;
import ru.yandex.msearch.proxy.HttpServer.RequestContext;
import ru.yandex.msearch.proxy.httpclient.CommonHttpClient;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public class UserInfo
{
private String sessionId;
private static HttpHost BLACKBOX_HOST;
private static HttpHost CORP_BLACKBOX_HOST;
private static long CORP_UID_BEGIN = 1120000000000000L;
private static long CORP_UID_END = 1130000000000000L;
private static HttpRequestRetryHandler httpRetryHandler = new DefaultHttpRequestRetryHandler( 2, true );
private String uid;
private boolean requested;
private String suid;
private String mailDb;
private String language;
private RequestContext ctx;
private static Tvm2TicketRenewalTask blackboxTvm2RenewalTask;
private static Tvm2TicketRenewalTask corpBlackboxTvm2RenewalTask;

private static HttpClient httpClient;

    public static void init(
        final ImmutableMsearchProxyConfig proxyConfig)
        throws ConfigException
    {
        BLACKBOX_HOST = proxyConfig.blackboxConfig().host();
        CORP_BLACKBOX_HOST = proxyConfig.corpBlackboxConfig().host();
        RequestConfig rqConfig = RequestConfig.custom()
                .setSocketTimeout( 3000 )
                .setConnectTimeout( 2000 )
                .setExpectContinueEnabled( false )
                .setStaleConnectionCheckEnabled( false )
                .build();
        httpClient = CommonHttpClient.httpClientBuilder
                .setDefaultRequestConfig(rqConfig)
                .setRetryHandler( httpRetryHandler )
                .build();
    }

	public static synchronized void blackboxTvm2RenewalTask(
		final Tvm2TicketRenewalTask blackboxTvm2RenewalTask)
	{
		UserInfo.blackboxTvm2RenewalTask = blackboxTvm2RenewalTask;
	}

	public static synchronized void corpBlackboxTvm2RenewalTask(
		final Tvm2TicketRenewalTask corpBlackboxTvm2RenewalTask)
	{
		UserInfo.corpBlackboxTvm2RenewalTask = corpBlackboxTvm2RenewalTask;
	}

	public UserInfo(RequestContext ctx, String uid )
    {
	this.ctx = ctx;
	this.uid = uid;
	suid = null;
	mailDb = null;
	language = null;
	requested = false;
//	requested = true;
//	suid = "142062698";
//	suid = "1120000000013747";
//	mailDb = "mdb300";
    }

    public String getSuid() throws MsearchProxyException
    {
	if( !requested ) request();
	return suid;
    }

    public String getUid() {
        return uid;
    }

    public String getMailDb() throws MsearchProxyException
    {
	if( !requested ) request();
	return mailDb;
    }

    public String getLanguage() throws MsearchProxyException
    {
	if( !requested ) request();
	if( language != null ) return language;
	return "ru";
    }

    private void request() throws MsearchProxyException
    {

    	boolean corp = false;
	HttpHost blackboxHost = BLACKBOX_HOST;
	try {
	    long longUid = Long.parseLong( uid );
	    if( longUid >= CORP_UID_BEGIN && longUid < CORP_UID_END ) {
	    	corp = true;
	       blackboxHost = CORP_BLACKBOX_HOST;
	    }
	} catch (NumberFormatException e) {
	    ctx.log.err( "BlackBox: can't parse long from uid: " + uid );
	}
	String url = "/blackbox?method=userinfo&uid=" + uid + "&userip=127.0.0.1&dbfields=subscription.suid.2,hosts.db_id.2,userinfo.lang.uid";
//	URLConnection conn = null;
//	InputStreamReader r = null;
	HttpEntity httpEntity = null;
	BufferedReader r = null;
	InputStream is = null;
	ctx.log.info( "BlackBox: blackbox request url: " + url );
	try {
//	    conn = new URL( url ).openConnection();
		String ticket;
		if (corp) {
			ticket = corpBlackboxTvm2RenewalTask.ticket();
		} else {
			ticket = blackboxTvm2RenewalTask.ticket();
		}

	    HttpGet httpGet = new HttpGet( url );
	    httpGet.addHeader(
	    	YandexHeaders.X_YA_SERVICE_TICKET,
			ticket);
//	    conn.setRequestProperty( "Cookie", imapCookie );
//	    conn.connect();

        MeasurableHttpContext context = new MeasurableHttpContext();
        HttpResponse response =
            httpClient.execute(blackboxHost, httpGet, context);
        ctx.log.info(context.finAndGetInfo());
	    httpEntity = response.getEntity();

	    if( httpEntity != null )
	    {
		try
		{
		    is = httpEntity.getContent();
		    r = new BufferedReader( new InputStreamReader( is, "UTF-8" ) );
		    parsePassportXml( r );
		}
		catch( RuntimeException ex )
		{
		    httpGet.abort();
		    throw ex;
		}
	    }
	    else
	    {
		ctx.log.err( "BlackBox: blackbox error: " + response.getStatusLine() );
	    }

	} catch (IOException e) {
	    throw new MsearchProxyException("Request to blackbox failed", e);
	} finally {
//	    if( out != null ) out.close();
            try {
	        if( is != null ) is.close();
	        if( r != null ) r.close();
	    } catch (IOException ign) {
	    }
//	    if( conn != null ) conn.close();
	}
    }

    private Node getNode( Node node, String name )
    {
	NodeList nl = node.getChildNodes();
	for( int i = 0; i < nl.getLength(); i++ )
	{
	    Node n = nl.item(i);
	    if( n.getNodeName().equalsIgnoreCase(name) ) return n;
	}
	return null;
    }

    private String getNodeText( Node n )
    {
	Node textNode = getNode( n, "#text" );
	if( textNode == null ) return "";
	String text = textNode.getNodeValue();
	if( text == null ) return "";
	return text;
    }

    private String getAttribute( Node n, String name )
    {
	String value;
	Node item = n.getAttributes().getNamedItem( name );
	if( item == null ) return "";
	value = item.getNodeValue();
	if( value == null ) return "";
	return value;
    }

    private final void checkField( String field, String name ) throws MsearchProxyException
    {
	if( field == null || (field != null && field.isEmpty()) )
	    throw new MsearchProxyException( "BlackBox error: " + name + " field is empty" );
    }

    private void listNodes( Node node )
    {
	NodeList nl = node.getChildNodes();
	for( int i = 0; i < nl.getLength(); i++ )
	{
	    Node n = nl.item(i);
	    System.err.println( n.getNodeName() );
	}
    }

    private void parsePassportXml( BufferedReader r ) throws MsearchProxyException
    {
        try {
            Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse( new InputSource(r) );
            if( doc == null ) throw new MsearchProxyException( "BlackBox answer parse error: unknown error" );

            Node docNode = getNode( doc, "doc" );
            if( docNode == null ) throw new MsearchProxyException( "BlackBox answer parse error: <doc> node not found" );

            Node exception = getNode( docNode, "exception" );
            if( exception != null )
            {
//	        listNodes( exception );
	        String errorMsg = getNodeText( exception );//.getNodeValue();
	        Node errorNode = getNode( docNode, "error" );
	        if( errorNode != null ) errorMsg += "; " + getNodeText( errorNode );
	        throw new MsearchProxyException( "BlackBox error: " + errorMsg );
	    }

	    NodeList nl = docNode.getChildNodes();
	    for( int i = 0; i < nl.getLength(); i++ )
	    {
	        Node n = nl.item(i);
	        if( n.getNodeName().equalsIgnoreCase("dbfield") )
	        {
	            if( getAttribute(n, "id").equalsIgnoreCase("hosts.db_id.2") )
	            {
	                mailDb = getNodeText( n );
		    }
		    else if( getAttribute(n, "id").equalsIgnoreCase("userinfo.lang.uid") )
		    {
		        language = getNodeText( n );
		    }
		    else if( getAttribute(n, "id").equalsIgnoreCase("subscription.suid.2") )
		    {
		        suid = getNodeText( n );
		        if( suid.isEmpty() )
		        {
		            throw new ApiException( "BlackBox error: user has no mail subscription", 404 );
		        }
		    }
	        }
	    }
	    checkField( suid, "suid" );
	    checkField( mailDb, "maildb" );
	    requested = true;
	    ctx.log.info( "BlackBox: UserInfo: maildb=" + mailDb + ", suid=" + suid + ", language=" + language );
        } catch (SAXException|ParserConfigurationException|IOException e) {
            throw new MsearchProxyException("PassportXmlParsingFailed", e);
        }
    }
}
