package ru.yandex.msearch.proxy.api.mail;

import java.util.Iterator;
import java.util.TreeMap;
import java.util.Map;
import java.util.Arrays;
import java.io.PrintStream;
import java.io.OutputStreamWriter;
import java.io.IOException;
import org.json.JSONWriter;
import java.net.URLEncoder;
import com.tecnick.htmlutils.htmlentities.HTMLEntities;

import ru.yandex.msearch.proxy.logger.Logger;
import ru.yandex.msearch.proxy.document.Document;
import ru.yandex.msearch.proxy.collector.Collector;

public class XMLMailPrinter
{
Map<String,String> params;
int perPage;

    public XMLMailPrinter( int perPage )
    {
	this.perPage = perPage;
    }
    
    public int print( Collector collector, PrintStream ps, int offset, int length )
    {
	Map<Document,Document> hits = collector.hits();
	Iterator<Document> iter = hits.keySet().iterator();

	return printXml( ps, iter, offset, length );
    }
    
    private int printXml( PrintStream ps, Iterator<Document> iter, int offset, int length )
    {
	ps.println( "<yamail>" );
	ps.println( "<search_results>" );
	ps.println( "<details crc32=\"123\" my_email=\"0\" page_number=\"" + (offset / perPage) + 1 + "\" request=\"\" tz=\"Europe/Moscow\"/>" );
	int i = 0;
	while( iter.hasNext() )
	{
	    Document doc = iter.next();
	    if( i++ < offset ) continue;
	    if( i > length + offset ) break;
	    ps.println( "<message>" );
	    Map<String,String> attrs = doc.getAttrs();
	    Iterator<Map.Entry<String,String>> attrIter = attrs.entrySet().iterator();
	    while( attrIter.hasNext() )
	    {
		Map.Entry<String,String> entry = attrIter.next();
		if( entry.getKey().equals("_relevant_") ) continue;
		if( entry.getValue().length() > 0 )
		{
		    ps.print( "<" + entry.getKey() + ">" );
		    ps.print( encode(entry.getValue()) );
		    ps.println( "</" + entry.getKey() + ">" );
		}
		else
		{
		    ps.println( "<" + entry.getKey() + "/>" );
		}
	    }
	    ps.println( "</message>" );
	}
	ps.println( "</search_results>" );
	ps.println( "</yamail>" );
	
	return i - offset;
    }

    private String encode( String in )
    {
	return HTMLEntities.htmlAngleBrackets( HTMLEntities.htmlAmpersand( in ) );
//	return HTMLEntities.htmlentities( in );
//        try
//        {
//	    URLEncoder.encode( in, "UTF-8");
//	}
//	catch( Exception e ){};
//	return in;
    }


}

