package ru.yandex.msearch.proxy.api.mail.rules;

import ru.yandex.msearch.proxy.HttpServer;
import ru.yandex.msearch.proxy.MsearchProxyException;
import ru.yandex.msearch.proxy.api.ApiException;
import ru.yandex.msearch.proxy.api.mail.MailSearchResult;

public abstract class ChainedSearchRule implements SearchRule {
    protected SearchRule next = null;

    public void setNext(final SearchRule next) {
        this.next = next;
    }

    public MailSearchResult next(
        final HttpServer.RequestContext ctx,
        final HttpServer.HttpParams params,
        final int length)
        throws ApiException, MsearchProxyException
    {
        if (next == null) {
            return null;
        } else {
            return next.execute(ctx, params, length);
        }
    }
}

