package ru.yandex.msearch.proxy.api.mail.rules;

import java.util.regex.Pattern;

import ru.yandex.msearch.proxy.HttpServer;
import ru.yandex.msearch.proxy.MsearchProxyException;
import ru.yandex.msearch.proxy.api.ApiException;
import ru.yandex.msearch.proxy.api.mail.MailSearchResult;

public class ForbiddenRequestsRule extends ChainedSearchRule {
    private final Pattern pattern;

    public ForbiddenRequestsRule(final Pattern pattern) {
        this.pattern = pattern;
    }

    @Override
    public MailSearchResult execute(
        final HttpServer.RequestContext ctx,
        final HttpServer.HttpParams params,
        final int length)
        throws ApiException, MsearchProxyException
    {
        String text = params.get("request");
        if (params.getBoolean("imap", false)
            && text != null
            && pattern.matcher(text).matches())
        {
            ctx.log.err("request banned: " + text);
            ctx.setHttpCode(403);
            ctx.ps().println("request '" + text + "' is forbidden by "
                + pattern);
            return null;
        }
        return next(ctx, params, length);
    }
}

