package ru.yandex.msearch.proxy.api.mail.rules;

import ru.yandex.msearch.proxy.HttpServer;
import ru.yandex.msearch.proxy.MsearchProxyException;
import ru.yandex.msearch.proxy.api.ApiException;
import ru.yandex.msearch.proxy.api.mail.MailSearchOptions;
import ru.yandex.msearch.proxy.api.mail.MailSearchResult;

public class RewriteScopeRule extends ChainedSearchRule {
    @Override
    public MailSearchResult execute(
        final HttpServer.RequestContext ctx,
        final HttpServer.HttpParams originalParams,
        final int length)
        throws ApiException, MsearchProxyException
    {
        HttpServer.HttpParams params = originalParams.copy();
        String scope = params.get("scope");
        if (scope != null && scope.isEmpty()) {
            scope = null;
            params.remove("scope");
        }
        String request = params.get("request");
        if (request != null && request.isEmpty()) {
            request = null;
            params.remove("request");
        }
        if (scope != null && request != null) {
            switch (scope) {
                case "history":
                    params.replace("imap", "1");
                    StringBuilder sb = new StringBuilder();
                    for (String email: request.split(" ")) {
                        if (sb.length() > 0) {
                            sb.append(" OR ");
                        }
                        sb.append("hdr_from:\"");
                        sb.append(email);
                        sb.append("\" OR hdr_to:\"");
                        sb.append(email);
                        sb.append('"');
                    }
                    params.replace("request", sb.toString());
                    break;
                case "rpopid":
                    params.replace("imap", "1");
                    params.replace("request",
                        "headers:\"_$XHIDENX$_x-yandex-rpop-id: " + request
                        + "\" OR headers:\"x-yandex-rpop-id: " + request
                        + '"');
                    params.remove("scope");
                    break;
                case "rpopinfo":
                    params.replace("imap", "1");
                    params.replace(
                        "request",
                        "headers:\"_$XHIDENX$_x-yandex-rpop-info: " + request
                        + "\" OR headers:\"x-yandex-rpop-info: " + request
                        + '"');
                    params.remove("scope");
                    break;
                case "imap":
                    params.replace("imap", "1");
                    params.replace(
                        "request",
                        request.replace("*", "").replace("?", ""));
                    params.remove("scope");
                    break;
                default:
                    break;
            }
        }
        return next(ctx, params, length);
    }
}

