package ru.yandex.msearch.proxy.api.mail.rules;

import java.util.concurrent.atomic.AtomicLong;

import ru.yandex.msearch.proxy.HttpServer;
import ru.yandex.msearch.proxy.MsearchProxyException;
import ru.yandex.msearch.proxy.api.ApiException;
import ru.yandex.msearch.proxy.api.mail.MailSearchOptions;
import ru.yandex.msearch.proxy.api.mail.MailSearchResult;
import ru.yandex.msearch.proxy.collector.SortingCollector;
import ru.yandex.msearch.proxy.config.ImmutableSoCheckConfig;
import ru.yandex.msearch.proxy.socheck.SoCheck;
import ru.yandex.msearch.proxy.socheck.SoCheckFactory;

public class SoCheckRule extends ChainedSearchRule {
    private final AtomicLong botNetRequestNumber = new AtomicLong();
    private final ImmutableSoCheckConfig soCheckConfig;
    private final SoCheckFactory soCheckFactory;

    public SoCheckRule(final SoCheckFactory soCheckFactory) {
        this.soCheckFactory = soCheckFactory;
        soCheckConfig = soCheckFactory.config();
    }

    @Override
    public MailSearchResult execute(
        final HttpServer.RequestContext ctx,
        final HttpServer.HttpParams params,
        final int length)
        throws ApiException, MsearchProxyException
    {
        String request = params.get("request");
        HttpServer.HttpParams paramsCopy = params.copy();
        paramsCopy.replace("text", request);
        paramsCopy.replace("db", params.get("mdb"));
        paramsCopy.replace("user", params.get("suid"));
        SoCheck soCheck = soCheckFactory.create(paramsCopy, ctx);
        MailSearchResult result = next(ctx, params, length);
        int found = result.collector().getTotalCount();
        SoCheck.Result soCheckResult = soCheck.result(found);
	ctx.log.info( "socheck: check result is: " + soCheckResult );
        if (soCheckResult == SoCheck.Result.SPAM) {
            if (soCheckConfig.banSpam()) {
                ctx.log.info("Looks like bot-net, dropping search results");
                String fakeRequest = soCheckConfig.fakeRequest();
                long fakeRequestInterval = soCheckConfig.fakeRequestInterval();
                long botNetRequestNumber =
                    this.botNetRequestNumber.incrementAndGet();
                if (fakeRequest != null
                    && !fakeRequest.isEmpty()
                    && fakeRequestInterval > 0L
                    && botNetRequestNumber % fakeRequestInterval == 0L)
                {
                    ctx.log.info("Performing fake request");
                    paramsCopy = params.copy();
                    paramsCopy.replace("request", fakeRequest);
                    paramsCopy.replace("force", "true");
                    result = next(ctx, paramsCopy, length);
                } else {
                    ctx.log.info("Returning empty SERP");
                    result = new MailSearchResult(
                        new SortingCollector("mid", "received_date"),
                        new MailSearchOptions(request));
                }
            } else {
                ctx.log.info("ban_spam is not set, ignoring SO check result");
            }
        }
        return result;
    }
}

