package ru.yandex.msearch.proxy.api.postmaster;

import java.io.UnsupportedEncodingException;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.StandardCharsets;

import java.util.Calendar;
import java.util.List;
import java.util.Map;

import ru.yandex.function.StringBuilderProcessorAdapter;
import ru.yandex.function.StringVoidProcessor;

import ru.yandex.msearch.proxy.HttpServer;
import ru.yandex.msearch.proxy.api.ServiceProcessor;

import ru.yandex.parser.uri.PctEncoder;
import ru.yandex.parser.uri.PctEncodingRule;

public class DateMonthDayRequestWidener implements RequestWidener {
    private final ServiceProcessor processor;
    private final HttpServer.HttpParams params;
    private final String origRequest;
    private int step = 0;

    public DateMonthDayRequestWidener(
        final ServiceProcessor processor,
        final HttpServer.HttpParams params)
    {
        this.processor = processor;
        this.params = params;
        origRequest = params.get("text");
    }

    @Override
    public String nextRequest() {
        return generateRequest(step++);
    }

    private String generateRequest(final int step) {
        Calendar cal = Calendar.getInstance();
        switch(step) {
            case 0: {
                //one day request
                final int year = cal.get(Calendar.YEAR);
                final int month = cal.get(Calendar.MONTH) + 1;
                final int day = cal.get(Calendar.DAY_OF_MONTH);
                StringBuilder sb = new StringBuilder();
                sb.append("year:");
                sb.append(year);
                sb.append(" AND ");
                sb.append("month:");
                sb.append(month);
                sb.append(" AND ");
                sb.append("day:");
                sb.append(day);
                sb.append(" AND ");
                sb.append('(');
                sb.append(origRequest);
                sb.append(')');
                return produceRequest(new String(sb));
            }
            case 1: {
                //tho days request
                final int year1 = cal.get(Calendar.YEAR);
                final int month1 = cal.get(Calendar.MONTH) + 1;
                final int day1 = cal.get(Calendar.DAY_OF_MONTH);
                cal.add(Calendar.DAY_OF_MONTH, -1);
                final int year2 = cal.get(Calendar.YEAR);
                final int month2 = cal.get(Calendar.MONTH) + 1;
                final int day2 = cal.get(Calendar.DAY_OF_MONTH);
                StringBuilder sb = new StringBuilder();
                if (year1 == year2 && month1 == month2) {
                    sb.append("year:");
                    sb.append(year1);
                    sb.append(" AND ");
                    sb.append("month:");
                    sb.append(month1);
                    sb.append(" AND ");
                    sb.append("day:");
                    sb.append('(');
                    sb.append(day1);
                    sb.append(' ');
                    sb.append(day2);
                    sb.append(')');
                } else {
                    sb.append('(');
                    sb.append('(');
                    sb.append("year:");
                    sb.append(year1);
                    sb.append(" AND ");
                    sb.append("month:");
                    sb.append(month1);
                    sb.append(" AND ");
                    sb.append("day:");
                    sb.append(day1);
                    sb.append(')');
                    sb.append(" OR ");
                    sb.append('(');
                    sb.append("year:");
                    sb.append(year2);
                    sb.append(" AND ");
                    sb.append("month:");
                    sb.append(month2);
                    sb.append(" AND ");
                    sb.append("day:");
                    sb.append(day2);
                    sb.append(')');
                    sb.append(')');
                }
                sb.append(" AND ");
                sb.append('(');
                sb.append(origRequest);
                sb.append(')');
                return produceRequest(new String(sb));
            }
            case 2: {
                //one month request
                final int year = cal.get(Calendar.YEAR);
                final int month = cal.get(Calendar.MONTH) + 1;
                StringBuilder sb = new StringBuilder();
                sb.append("year:");
                sb.append(year);
                sb.append(" AND ");
                sb.append("month:");
                sb.append(month);
                sb.append(" AND ");
                sb.append('(');
                sb.append(origRequest);
                sb.append(')');
                return produceRequest(new String(sb));
            }
            case 3: {
                //two month request
                final int year1 = cal.get(Calendar.YEAR);
                final int month1 = cal.get(Calendar.MONTH) + 1;
                cal.add(Calendar.MONTH, -1);
                final int year2 = cal.get(Calendar.YEAR);
                final int month2 = cal.get(Calendar.MONTH) + 1;
                StringBuilder sb = new StringBuilder();
                if (year1 == year2) {
                    sb.append("year:");
                    sb.append(year1);
                    sb.append(" AND ");
                    sb.append("month:");
                    sb.append('(');
                    sb.append(month1);
                    sb.append(' ');
                    sb.append(month2);
                    sb.append(')');
                } else {
                    sb.append('(');
                    sb.append('(');
                    sb.append("year:");
                    sb.append(year1);
                    sb.append(" AND ");
                    sb.append("month:");
                    sb.append(month1);
                    sb.append(')');
                    sb.append(" OR ");
                    sb.append('(');
                    sb.append("year:");
                    sb.append(year2);
                    sb.append(" AND ");
                    sb.append("month:");
                    sb.append(month2);
                    sb.append(')');
                    sb.append(')');
                }
                sb.append(" AND ");
                sb.append('(');
                sb.append(origRequest);
                sb.append(')');
                return produceRequest(new String(sb));
            }
            case 4: {
                //one year request
                final int year = cal.get(Calendar.YEAR);
                StringBuilder sb = new StringBuilder();
                sb.append("year:");
                sb.append(year);
                sb.append(" AND ");
                sb.append('(');
                sb.append(origRequest);
                sb.append(')');
                return produceRequest(new String(sb));
            }
            case 5:
                //original request
                return produceRequest(origRequest);
            default:
                return null;
        }
    }

    private String produceRequest(final String text) {
        StringBuilder sb = new StringBuilder();
        sb.append('/');
        sb.append(processor.api());
        sb.append('?');

        CharsetEncoder errorLessEncoder = StandardCharsets.UTF_8.newEncoder()
            .onMalformedInput(CodingErrorAction.IGNORE)
            .onUnmappableCharacter(CodingErrorAction.IGNORE);
        StringVoidProcessor<char[], CharacterCodingException> encoder =
            new StringVoidProcessor<>(
                new PctEncoder(PctEncodingRule.QUERY, errorLessEncoder));
        StringBuilderProcessorAdapter sbAdapter =
            new StringBuilderProcessorAdapter(sb);

        String sep = "";
        for (Map.Entry<String, List<String>> entry : params.entrySet()) {
            final String key = entry.getKey();
            final List<String> values = entry.getValue();
            sb.append(sep);
            if (key.equals("text")) {
                sb.append(key);
                sb.append('=');
                try {
                    encoder.process(text);
                    encoder.processWith(sbAdapter);
                } catch (CharacterCodingException e) {
                    sb.append(text);
                }
                sep = "&";
            } else {
                for (String value  : values) {
                    sb.append(key);
                    if (value != null && value.length() > 0) {
                        sb.append('=');
                        try {
                            encoder.process(value);
                            encoder.processWith(sbAdapter);
                        } catch (CharacterCodingException e) {
                            sb.append(value);
                        }
                    }
                    sep = "&";
                }
            }
        }
        return sb.toString();
    }
}
