package ru.yandex.msearch.proxy.api.suggest;

import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Set;

import ru.yandex.msearch.proxy.api.async.mail.Side;

public class Translit
{
    private static final HashMap<Character,Character[]> translitMap = initTranslitMap();
    private static final HashMap<CharArray,Character[]> unTranslitMap = initUnTranslitMap();
    private static final HashMap<Character,Character> layoutEnRuMap = initLayoutEnRuMap();
    private static final HashMap<Character,Character> layoutRuEnMap = initLayoutRuEnMap();

    private static final int NEUTRAL = 0;

    private static final int UPPER = 1;

    private static final int LOWER = 2;

    private static HashMap<Character,Character[]> initTranslitMap()
    {
        HashMap<Character,Character[]> translitMap = new HashMap<Character,Character[]>();
        translitMap.put(new Character('а'), new Character[] {'a'});
        translitMap.put(new Character('б'), new Character[] {'b'});
        translitMap.put(new Character('в'), new Character[] {'v'});
        translitMap.put(new Character('г'), new Character[] {'g'});
        translitMap.put(new Character('д'), new Character[] {'d'});
        translitMap.put(new Character('е'), new Character[] {'e'});
        translitMap.put(new Character('ё'), new Character[] {'y','o'});
        translitMap.put(new Character('ж'), new Character[] {'z','h'});
        translitMap.put(new Character('з'), new Character[] {'z'});
        translitMap.put(new Character('и'), new Character[] {'i'});
        translitMap.put(new Character('й'), new Character[] {'j'});
        translitMap.put(new Character('к'), new Character[] {'k'});
        translitMap.put(new Character('л'), new Character[] {'l'});
        translitMap.put(new Character('м'), new Character[] {'m'});
        translitMap.put(new Character('н'), new Character[] {'n'});
        translitMap.put(new Character('о'), new Character[] {'o'});
        translitMap.put(new Character('п'), new Character[] {'p'});
        translitMap.put(new Character('р'), new Character[] {'r'});
        translitMap.put(new Character('с'), new Character[] {'s'});
        translitMap.put(new Character('т'), new Character[] {'t'});
        translitMap.put(new Character('у'), new Character[] {'u'});
        translitMap.put(new Character('ф'), new Character[] {'f'});
        translitMap.put(new Character('х'), new Character[] {'h'});
        translitMap.put(new Character('ц'), new Character[] {'t','s'});
        translitMap.put(new Character('ч'), new Character[] {'c','h'});
        translitMap.put(new Character('ш'), new Character[] {'s','h'});
        translitMap.put(new Character('щ'), new Character[] {'s','h'});
        translitMap.put(new Character('ъ'), new Character[] {'`'});
        translitMap.put(new Character('ы'), new Character[] {'y'});
//        translitMap.put(new Character('ь'), new Character[] {'\''});
        translitMap.put(new Character('э'), new Character[] {'e'});
        translitMap.put(new Character('ю'), new Character[] {'y','u'});
        translitMap.put(new Character('я'), new Character[] {'y','a'});
        translitMap.put(new Character('«'), new Character[] {'\"'});
        translitMap.put(new Character('»'), new Character[] {'\"'});
        translitMap.put(new Character('№'), new Character[] {'N','o'});
        return translitMap;
    }

    private static class CharArray
    {
        public Character[] array;

        public CharArray( Character[] array )
        {
            this.array = array;
        }

        public int hashCode()
        {
        int h = 0;
            for( Character c : array )
            {
                h += c;
                h <<= 2;
            }
            return h;
        }

        @Override
        public boolean equals( Object o )
        {
            CharArray other = (CharArray)o;
            if( other.array.length != array.length ) return false;
            for( int i = 0; i < array.length; i++ )
            {
                if( !array[i].equals(other.array[i]) ) return false;
            }
            return true;
        }

    }

    private static HashMap<CharArray,Character[]> initUnTranslitMap()
    {
        HashMap<CharArray,Character[]> translitMap = new HashMap<CharArray,Character[]>();
        translitMap.put(new CharArray(new Character[] {'a'}), new Character[]{ 'а' });
        translitMap.put(new CharArray(new Character[] {'b'}), new Character[]{ 'б' });
        translitMap.put(new CharArray(new Character[] {'v'}), new Character[]{ 'в' });
        translitMap.put(new CharArray(new Character[] {'g'}), new Character[]{'г'});
        translitMap.put(new CharArray(new Character[] {'d'}), new Character[]{'д'});
        translitMap.put(new CharArray(new Character[] {'e'}), new Character[]{ 'е'});
        translitMap.put(new CharArray(new Character[] {'y','o'}), new Character[]{'ё'});
        translitMap.put(new CharArray(new Character[] {'z','h'}), new Character[]{'ж'});
        translitMap.put(new CharArray(new Character[] {'z'}), new Character[]{'з'});
        translitMap.put(new CharArray(new Character[] {'i'}), new Character[]{'и'});
        translitMap.put(new CharArray(new Character[] {'j'}), new Character[]{'й'});
        translitMap.put(new CharArray(new Character[] {'k'}), new Character[]{'к'});
        translitMap.put(new CharArray(new Character[] {'l'}), new Character[]{'л'});
        translitMap.put(new CharArray(new Character[] {'m'}), new Character[]{'м'});
        translitMap.put(new CharArray(new Character[] {'n'}), new Character[]{'н'});
        translitMap.put(new CharArray(new Character[] {'o'}), new Character[]{'о'});
        translitMap.put(new CharArray(new Character[] {'p'}), new Character[]{'п'});
        translitMap.put(new CharArray(new Character[] {'r'}), new Character[]{'р'});
        translitMap.put(new CharArray(new Character[] {'s'}), new Character[]{'с'});
        translitMap.put(new CharArray(new Character[] {'t'}), new Character[]{'т'});
        translitMap.put(new CharArray(new Character[] {'u'}), new Character[]{'у'});
        translitMap.put(new CharArray(new Character[] {'x'}), new Character[]{'к','с'});
        translitMap.put(new CharArray(new Character[] {'f'}), new Character[]{'ф'});
        translitMap.put(new CharArray(new Character[] {'h'}), new Character[]{'х'});
        translitMap.put(new CharArray(new Character[] {'k','h'}), new Character[]{'х'});
        translitMap.put(new CharArray(new Character[] {'t','s'}), new Character[]{'ц'});
        translitMap.put(new CharArray(new Character[] {'c','h'}), new Character[]{'ч'});
        translitMap.put(new CharArray(new Character[] {'s','h'}), new Character[]{'ш'});
        translitMap.put(new CharArray(new Character[] {'s','h'}), new Character[]{'щ'});
        translitMap.put(new CharArray(new Character[] {'`'}), new Character[]{'ъ'});
        translitMap.put(new CharArray(new Character[] {'y'}), new Character[]{'ы'});
        translitMap.put(new CharArray(new Character[] {'\''}), new Character[]{'ь'});
//        translitMap.put(new CharArray(new Character[] {'e'}), new Character('э'));
        translitMap.put(new CharArray(new Character[] {'y','u'}), new Character[]{'ю'});
        translitMap.put(new CharArray(new Character[] {'y','a'}), new Character[]{'я'});
        translitMap.put(new CharArray(new Character[] {'j','u'}), new Character[]{'ю'});
        translitMap.put(new CharArray(new Character[] {'j','a'}), new Character[]{'я'});
//        translitMap.put(new Character[] {'\"'}, new Character('«'));
//        translitMap.put(new Character[] {'\"'}, new Character('»'));
//        translitMap.put(new Character[] {'N','o'}new Character('№'));
        return translitMap;
    }

    private static HashMap<Character,Character> initLayoutEnRuMap()
    {
        HashMap<Character,Character> map = new HashMap<Character,Character>();
        map.put(new Character('q'), new Character('й'));
        map.put(new Character('w'), new Character('ц'));
        map.put(new Character('e'), new Character('у'));
        map.put(new Character('r'), new Character('к'));
        map.put(new Character('t'), new Character('е'));
        map.put(new Character('y'), new Character('н'));
        map.put(new Character('u'), new Character('г'));
        map.put(new Character('i'), new Character('ш'));
        map.put(new Character('o'), new Character('щ'));
        map.put(new Character('p'), new Character('з'));
        map.put(new Character('['), new Character('х'));
        map.put(new Character(']'), new Character('ъ'));
        map.put(new Character('a'), new Character('ф'));
        map.put(new Character('s'), new Character('ы'));
        map.put(new Character('d'), new Character('в'));
        map.put(new Character('f'), new Character('а'));
        map.put(new Character('g'), new Character('п'));
        map.put(new Character('h'), new Character('р'));
        map.put(new Character('j'), new Character('о'));
        map.put(new Character('k'), new Character('л'));
        map.put(new Character('l'), new Character('д'));
        map.put(new Character(';'), new Character('ж'));
        map.put(new Character('\''), new Character('э'));
        map.put(new Character('z'), new Character('я'));
        map.put(new Character('x'), new Character('ч'));
        map.put(new Character('c'), new Character('с'));
        map.put(new Character('v'), new Character('м'));
        map.put(new Character('b'), new Character('и'));
        map.put(new Character('n'), new Character('т'));
        map.put(new Character('m'), new Character('ь'));
        map.put(new Character(','), new Character('б'));
        map.put(new Character('.'), new Character('ю'));
//        map.put(new Character('/'), new Character[] {'y','u'});
//        map.put(new Character('я'), new Character[] {'y','a'});
//        map.put(new Character('«'), new Character[] {'\"'});
//        map.put(new Character('»'), new Character[] {'\"'});
//        map.put(new Character('№'), new Character[] {'N','o'});
        return map;
    }

    private static HashMap<Character,Character> initLayoutRuEnMap()
    {
        HashMap<Character,Character> map = new HashMap<Character,Character>();
        map.put(new Character('й'), new Character('q'));
        map.put(new Character('ц'), new Character('w'));
        map.put(new Character('у'), new Character('e'));
        map.put(new Character('к'), new Character('r'));
        map.put(new Character('е'), new Character('t'));
        map.put(new Character('н'), new Character('y'));
        map.put(new Character('г'), new Character('u'));
        map.put(new Character('ш'), new Character('i'));
        map.put(new Character('щ'), new Character('o'));
        map.put(new Character('з'), new Character('p'));
//        map.put(new Character('х'), new Character('['));
//        map.put(new Character('ъ'), new Character(']'));
        map.put(new Character('ф'), new Character('a'));
        map.put(new Character('ы'), new Character('s'));
        map.put(new Character('в'), new Character('d'));
        map.put(new Character('а'), new Character('f'));
        map.put(new Character('п'), new Character('g'));
        map.put(new Character('р'), new Character('h'));
        map.put(new Character('о'), new Character('j'));
        map.put(new Character('л'), new Character('k'));
        map.put(new Character('д'), new Character('l'));
//        map.put(new Character('ж'), new Character(';'));
//        map.put(new Character('э'), new Character('\''));
        map.put(new Character('я'), new Character('z'));
        map.put(new Character('ч'), new Character('x'));
        map.put(new Character('с'), new Character('c'));
        map.put(new Character('м'), new Character('v'));
        map.put(new Character('и'), new Character('b'));
        map.put(new Character('т'), new Character('n'));
        map.put(new Character('ь'), new Character('m'));
        map.put(new Character('б'), new Character(','));
        map.put(new Character('ю'), new Character('.'));
//        map.put(new Character('/'), new Character[] {'y','u'});
//        map.put(new Character('я'), new Character[] {'y','a'});
//        map.put(new Character('«'), new Character[] {'\"'});
//        map.put(new Character('»'), new Character[] {'\"'});
//        map.put(new Character('№'), new Character[] {'N','o'});
        return map;
    }

    private final static int charClass( char c )
    {
        if( Character.isLowerCase(c) )
            return LOWER;
        if( Character.isUpperCase(c) )
            return UPPER;
        return NEUTRAL;
    }

    private final static Character fromClass( Character c, int charClass )
    {
        switch( charClass )
        {
            case LOWER:
            case NEUTRAL:
                return c;
            case UPPER:
                return Character.toUpperCase(c);
            default:
                return c;
        }
    }

    public static final String layoutRuEn( String str )
    {
        StringBuilder sb = new StringBuilder();
        for( int i = 0; i < str.length(); i++ )
        {
            Character strChar = str.charAt(i);
            Character strCharLower = Character.toLowerCase(strChar);
            int charClass = charClass(strChar);

            Character replace = layoutRuEnMap.get(strCharLower);
            if( replace == null )
            {
                sb.append( strChar );
            }
            else
            {
                sb.append( fromClass(replace, charClass) );
            }
        }
        return sb.toString();
    }

    public static final String layoutEnRu( String str )
    {
        StringBuilder sb = new StringBuilder();
        for( int i = 0; i < str.length(); i++ )
        {
            Character strChar = str.charAt(i);
            Character strCharLower = Character.toLowerCase(strChar);
            int charClass = charClass(strChar);

            Character replace = layoutEnRuMap.get(strCharLower);
            if( replace == null )
            {
                sb.append( strChar );
            }
            else
            {
                sb.append( fromClass(replace, charClass) );
            }
        }
        return sb.toString();
    }

    public static final String translit( String str )
    {
        StringBuilder sb = new StringBuilder();
        for( int i = 0; i < str.length(); i++ )
        {
            Character strChar = str.charAt(i);
            Character strCharLower = Character.toLowerCase(strChar);
            int charClass = charClass(strChar);

            Character[] replace = translitMap.get(strCharLower);
            if( replace == null )
            {
                sb.append( strChar );
            }
            else
            {
                for( Character r : replace )
                {
                    sb.append( fromClass(r, charClass) );
                }
            }
        }
        return sb.toString();
    }

    public static final String unTranslit( String str )
    {
        StringBuilder sb = new StringBuilder();
        CharArray needle = new CharArray( new Character[1] );
        CharArray tupple = new CharArray( new Character[2] );
        int i;
        for( i = 0; i < str.length() - 1; i++ )
        {
            Character c1 = str.charAt(i);
            Character c2 = str.charAt(i+1);
            tupple.array[0] = Character.toLowerCase(c1);
            tupple.array[1] = Character.toLowerCase(c2);
            int c1c = charClass(c1);
            Character[] replace = unTranslitMap.get(tupple);
            if( replace == null )
            {
                needle.array[0] = tupple.array[0];
                replace = unTranslitMap.get(needle);
                if( replace == null )
                {
                    sb.append( c1 );
                }
                else
                {
                    for( Character r : replace )
                    {
                        sb.append( fromClass( r, c1c ) );
                    }
                }
            }
            else
            {
                for( Character r : replace )
                {
                    sb.append( fromClass( r, c1c ) );
                }
                i++;
            }
        }
        if( i < str.length() ) //one symbol left
        {
            Character c1 = str.charAt(i);
            needle.array[0] = Character.toLowerCase(c1);
            int c1c = charClass(c1);
            Character[] replace = unTranslitMap.get(needle);
            if( replace == null )
            {
                sb.append( c1 );
            }
            else
            {
                for( Character r : replace )
                {
                    sb.append( fromClass( r, c1c ) );
                }
            }
        }
        return sb.toString();
    }

    public static Set<String> suggestSet(final String str, final Side side) {
        Set<String> translit = new LinkedHashSet<>();
        translit.add(str);
        translit.add(translit(str));
        translit.add(unTranslit(str));
        if (side.equals(Side.WEB) || side.equals(Side.UNKNOWN)) {
            translit.add(layoutRuEn(str));
            translit.add(layoutEnRu(str));
        }
        return translit;
    }
}
