package ru.yandex.msearch.proxy.collector;

import java.util.Map;
import java.util.LinkedHashMap;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.Vector;
import java.io.PrintStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.IOException;

import ru.yandex.msearch.proxy.document.Document;

public class LinkedHashCollector extends Collector
{

private int totalCount = 0;
private LinkedHashMap<Document,Document> hits;
private String orderBy;
private String groupBy;
private boolean ascending;

    public LinkedHashCollector( String groupBy )
    {
	this.groupBy = groupBy;
	ascending = false;
	this.hits = new LinkedHashMap<Document,Document>();
    }

    @Override
    public synchronized void incTotalCount( int inc )
    {
	totalCount += inc;
    }

    @Override
    public int getTotalCount()
    {
	return totalCount;
    }

    @Override
    public int getCount()
    {
	return hits.keySet().size();
    }

    @Override
    public Map<Document,Document> hits()
    {
	return hits;
    }

    @Override
    public synchronized void collect( Document doc )
    {
	if( doc == null ) return;
	doc.setGroupField(groupBy);
	Document oldDoc;
	oldDoc = hits.put(doc, doc);
	if( oldDoc != null )
	{
	    oldDoc.addMerged( doc );
	    totalCount--;
	    hits.put(oldDoc, oldDoc);
	}
    }
}

