package ru.yandex.msearch.proxy.collector;

import java.util.Map;
import java.util.TreeMap;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.Vector;
import java.util.concurrent.ConcurrentSkipListMap;
import java.io.PrintStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.IOException;

import ru.yandex.msearch.proxy.document.Document;
//import ru.yandex.msearch

public class SortingCollector extends Collector
{

private int totalCount = 0;
private TreeMap<Document,Document> hits;
private String orderBy;
private String groupBy;
//private String sessionId;
private boolean ascending;

    public SortingCollector( String groupBy, String orderBy )
//    public SortingCollector( String sessionId, Map<String,String> params )
    {
//	this.sessionId = sessionId;
	this.orderBy = orderBy;
	this.groupBy = groupBy;
	ascending = false;
	this.hits = new TreeMap<>(new DocComparator());
    }

    @Override
    public synchronized void incTotalCount( int inc )
    {
//	System.err.println( "Inc total count: " + inc );
	totalCount += inc;
//	System.err.println( "Inc total count: " + totalCount );
    }

    @Override
    public int getTotalCount()
    {
//	System.err.println( "get total count: " + totalCount );
	return totalCount;
    }

    @Override
    public int getCount()
    {
//	System.err.println( "get total count: " + totalCount );
	return hits.keySet().size();
    }

    @Override
    public Map<Document,Document> hits()
    {
	return hits;
    }

    @Override
    public synchronized void collect( Document doc )
    {
	if( doc == null ) return;
	doc.setOrderField(orderBy);
	doc.setGroupField(groupBy);
	Document oldDoc;
	oldDoc = hits.put(doc, doc);
	if( oldDoc != null )
	{
	    int cmp = doc.compareTo(oldDoc);
	    if( ascending )
	    {
	        if( cmp < 0 )
	        {
	            doc.setMerged( oldDoc.getMerged() );
	        }
	        else
	        {
	            oldDoc.addMerged( doc );
	            hits.put(oldDoc, oldDoc);
	        }
	    }
	    else
	    {
	        if( cmp > 0 )
	        {
	            doc.setMerged( oldDoc.getMerged() );
	        }
	        else
	        {
	            oldDoc.addMerged( doc );
	            hits.put(oldDoc, oldDoc);
	        }
	    }
	    totalCount--;
	}
    }

    private class DocComparator implements Comparator<Document> {
        @Override
	public int compare(final Document a, final Document b) {
	    if( a.equals(b) ) return 0;
	    if( ascending ) return a.compareTo(b);
	    else return b.compareTo(a);
	}
    }
}

