package ru.yandex.msearch.proxy.config;

import ru.yandex.client.tvm2.Tvm2ClientConfig;
import ru.yandex.client.tvm2.Tvm2ClientConfigBuilder;
import ru.yandex.http.config.FilterSearchConfig;
import ru.yandex.http.config.FilterSearchConfigBuilder;
import ru.yandex.http.config.HttpHostConfig;
import ru.yandex.http.config.HttpHostConfigBuilder;
import ru.yandex.http.config.HttpHostConfigDefaults;
import ru.yandex.http.config.URIConfig;
import ru.yandex.http.config.URIConfigBuilder;
import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;
import ru.yandex.search.proxy.universal.AbstractUniversalSearchProxyConfigBuilder;

public abstract class AbstractAsyncHttpServerBaseConfigBuilder
        <T extends AbstractAsyncHttpServerBaseConfigBuilder<T>>
        extends AbstractUniversalSearchProxyConfigBuilder<T>
        implements AsyncHttpServerBaseConfig
{
    private FilterSearchConfigBuilder filterSearchConfig;
    private URIConfigBuilder foldersConfig;
    private Tvm2ClientConfigBuilder filterSearchTvm2ClientConfig;
    private HttpHostConfigBuilder mopsClientConfig;
    private HttpHostConfigBuilder tupitaConfig;
    private HttpHostConfigBuilder furitaConfig;
    private HttpHostConfigBuilder producerStoreConfig;

    protected AbstractAsyncHttpServerBaseConfigBuilder(AsyncHttpServerBaseConfig config) {
        super(config);
        filterSearchConfig(config.filterSearchConfig());
        foldersConfig(config.foldersConfig());
        filterSearchTvm2ClientConfig(config.filterSearchTvm2ClientConfig());
        mopsClientConfig(config.mopsClientConfig());
        tupitaConfig(config.tupitaConfig());
        furitaConfig(config.furitaConfig());
        producerStoreConfig(config.producerStoreConfig());
    }

    protected AbstractAsyncHttpServerBaseConfigBuilder(IniConfig config, AsyncHttpServerBaseConfig defaults) throws ConfigException {
        super(config, defaults);

        foldersConfig = new URIConfigBuilder(
                config.section("folders"),
                defaults.foldersConfig());

        IniConfig filterSearchSection = config.section("filter-search");

        filterSearchTvm2ClientConfig = new Tvm2ClientConfigBuilder(
                filterSearchSection.section("tvm2"),
                defaults.filterSearchTvm2ClientConfig());

        filterSearchConfig = new FilterSearchConfigBuilder(
                filterSearchSection,
                defaults.filterSearchConfig());

        IniConfig mopsClientSection = config.sectionOrNull("mops");
        if (mopsClientSection != null) {
            HttpHostConfig mopsDefaults = defaults.mopsClientConfig();
            if (mopsDefaults == null) {
                mopsDefaults = HttpHostConfigDefaults.INSTANCE;
            }
            mopsClientConfig =
                    new HttpHostConfigBuilder(
                            mopsClientSection,
                            mopsDefaults);
        } else {
            mopsClientConfig = null;
        }

        IniConfig producerStoreSection = config.section("producer-store");
        if (producerStoreSection != null) {
            producerStoreConfig=
                    new HttpHostConfigBuilder(
                            producerStoreSection,
                            defaults.producerStoreConfig());
        } else {
            producerStoreConfig = null;
        }

        tupitaConfig = new HttpHostConfigBuilder(
                config.section("tupita"),
                defaults.tupitaConfig());
        furitaConfig = new HttpHostConfigBuilder(
                config.section("furita"),
                defaults.furitaConfig());
    }

    @Override
    public FilterSearchConfigBuilder filterSearchConfig() {
        return filterSearchConfig;
    }

    public T filterSearchConfig(final FilterSearchConfig filterSearchConfig) {
        this.filterSearchConfig =
                new FilterSearchConfigBuilder(filterSearchConfig);
        return self();
    }

    @Override
    public URIConfigBuilder foldersConfig() {
        return foldersConfig;
    }

    public T foldersConfig(final URIConfig foldersConfig) {
        this.foldersConfig = new URIConfigBuilder(foldersConfig);
        return self();
    }

    @Override
    public Tvm2ClientConfigBuilder filterSearchTvm2ClientConfig() {
        return filterSearchTvm2ClientConfig;
    }

    public T filterSearchTvm2ClientConfig(
            final Tvm2ClientConfig filterSearchTvm2ClientConfig)
    {
        this.filterSearchTvm2ClientConfig =
                new Tvm2ClientConfigBuilder(filterSearchTvm2ClientConfig);
        return self();
    }

    @Override
    public HttpHostConfigBuilder producerStoreConfig() {
        return producerStoreConfig;
    }

    public T producerStoreConfig(final HttpHostConfig config) {
        if (config != null) {
            this.producerStoreConfig = new HttpHostConfigBuilder(config);
        } else {
            this.producerStoreConfig = null;
        }

        return self();
    }

    @Override
    public HttpHostConfig mopsClientConfig() {
        return mopsClientConfig;
    }

    public T mopsClientConfig(final HttpHostConfig mopsClientConfig) {
        if (mopsClientConfig != null) {
            this.mopsClientConfig = new HttpHostConfigBuilder(mopsClientConfig);
        } else {
            this.mopsClientConfig = null;
        }

        return self();
    }

    @Override
    public HttpHostConfigBuilder tupitaConfig() {
        return tupitaConfig;
    }

    public T tupitaConfig(final HttpHostConfig tupitaConfig) {
        this.tupitaConfig = new HttpHostConfigBuilder(tupitaConfig);
        return self();
    }

    public HttpHostConfigBuilder furitaConfig() {
        return furitaConfig;
    }

    public T furitaConfig(final HttpHostConfig furitaConfig) {
        this.furitaConfig = new HttpHostConfigBuilder(furitaConfig);
        return self();
    }
}
