package ru.yandex.msearch.proxy.config;

import java.util.LinkedHashSet;
import java.util.Set;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;
import ru.yandex.parser.string.CollectionParser;
import ru.yandex.parser.string.NonEmptyValidator;

public abstract class AbstractChemodanConfigBuilder
    <T extends AbstractChemodanConfigBuilder<T>>
     implements ChemodanConfig
{
    private String webattachUrl;
    private String corpWebattachUrl;
    private int webattachTtl;
    private Set<String> previewableExtensions;
    private boolean ps3183Shield;

    protected AbstractChemodanConfigBuilder(final ChemodanConfig config) {
        webattachUrl(config.webattachUrl());
        corpWebattachUrl(config.corpWebattachUrl());
        webattachTtl(config.webattachTtl());
        previewableExtensions(config.previewableExtensions());
        ps3183Shield(config.ps3183Shield());
    }

    protected AbstractChemodanConfigBuilder(
        final IniConfig config,
        final ChemodanConfig defaults)
        throws ConfigException
    {
        this.webattachUrl =
            config.getString("webattach-url", defaults.webattachUrl());
        this.corpWebattachUrl =
            config.getString("corp-webattach-url", defaults.corpWebattachUrl());
        this.webattachTtl =
            config.getIntegerDuration("webattach-ttl", defaults.webattachTtl());
        this.ps3183Shield =
            config.getBoolean(
                "ps3183-shield",
                defaults.ps3183Shield());

        this.previewableExtensions =
            config.get(
                "previewable-extensions",
                defaults.previewableExtensions(),
                new CollectionParser<>(
                    NonEmptyValidator.TRIMMED,
                    LinkedHashSet::new));
    }

    public abstract T self();

    @Override()
    public String webattachUrl() {
        return webattachUrl;
    }

    public T webattachUrl(final String value) {
        this.webattachUrl = value;
        return self();
    }

    @Override()
    public String corpWebattachUrl() {
        return corpWebattachUrl;
    }

    public T corpWebattachUrl(final String value) {
        this.corpWebattachUrl = value;
        return self();
    }

    @Override()
    public int webattachTtl() {
        return webattachTtl;
    }

    public T webattachTtl(final int value) {
        this.webattachTtl = value;
        return self();
    }

    public T previewableExtensions(final Set<String> value) {
        this.previewableExtensions = new LinkedHashSet<>(value);
        return self();
    }

    @Override
    public Set<String> previewableExtensions() {
        return previewableExtensions;
    }

    @Override
    public boolean ps3183Shield() {
        return ps3183Shield;
    }

    public T ps3183Shield(final boolean ps3183Shield) {
        this.ps3183Shield = ps3183Shield;
        return self();
    }
}
