package ru.yandex.msearch.proxy.config;

import ru.yandex.parser.config.ConfigBuilder;
import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public abstract class AbstractDkimStatsConfigBuilder
    <T extends AbstractDkimStatsConfigBuilder<T>>
    implements ConfigBuilder<T>, DkimStatsConfig
{
    private Long failoverDelay;
    private long cacheTtl;
    private long cacheCapacity;
    private int updateConcurrency;
    private long retryInterval;

    protected AbstractDkimStatsConfigBuilder(final DkimStatsConfig config) {
        failoverDelay(config.failoverDelay());
        cacheTtl(config.cacheTtl());
        cacheCapacity(config.cacheCapacity());
        updateConcurrency(config.updateConcurrency());
        retryInterval(config.retryInterval());
    }

    protected AbstractDkimStatsConfigBuilder(
        final IniConfig config,
        final DkimStatsConfig defaults)
        throws ConfigException
    {
        failoverDelay =
            FAILOVER_DELAY.extract(config, defaults.failoverDelay());
        cacheTtl = CACHE_TTL.extract(config, defaults.cacheTtl());
        cacheCapacity =
            CACHE_CAPACITY.extract(config, defaults.cacheCapacity());
        updateConcurrency =
            UPDATE_CONCURRENCY.extract(config, defaults.updateConcurrency());
        retryInterval =
            RETRY_INTERVAL.extract(config, defaults.retryInterval());
    }

    @Override
    public Long failoverDelay() {
        return failoverDelay;
    }

    public T failoverDelay(final Long failoverDelay) {
        this.failoverDelay = failoverDelay;
        return self();
    }

    @Override
    public long cacheTtl() {
        return cacheTtl;
    }

    public T cacheTtl(final long cacheTtl) {
        this.cacheTtl = cacheTtl;
        return self();
    }

    @Override
    public long cacheCapacity() {
        return cacheCapacity;
    }

    public T cacheCapacity(final long cacheCapacity) {
        this.cacheCapacity = cacheCapacity;
        return self();
    }

    @Override
    public int updateConcurrency() {
        return updateConcurrency;
    }

    public T updateConcurrency(final int updateConcurrency) {
        this.updateConcurrency = updateConcurrency;
        return self();
    }

    @Override
    public long retryInterval() {
        return retryInterval;
    }

    public T retryInterval(final long retryInterval) {
        this.retryInterval = retryInterval;
        return self();
    }
}

