package ru.yandex.msearch.proxy.config;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

import ru.yandex.msearch.proxy.api.async.enlarge.Enlargeble;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public abstract class AbstractEnlargeConfigBuilder
    <T extends AbstractEnlargeConfigBuilder<T>>
    implements EnlargeConfig
{
    public Map<String, Enlargeble> enlargebles;

    protected AbstractEnlargeConfigBuilder(final EnlargeConfig config) {
        enlargebles = new HashMap<>(config.enlargebles());
    }

    protected AbstractEnlargeConfigBuilder(
        final IniConfig config,
        final EnlargeConfig defaults)
        throws ConfigException
    {
        Set<String> keys = config.keys();
        enlargebles = new HashMap<>(keys.size() << 1);
        for (String key: keys) {
            enlargebles.put(key, new Enlargeble(config.getString(key)));
        }
    }

    public abstract T self();

    @Override
    public Map<String, Enlargeble> enlargebles() {
        return enlargebles;
    }

    public T enlargebles(final Map<String, Enlargeble> enlargebles) {
        this.enlargebles = enlargebles;
        return self();
    }
}
