package ru.yandex.msearch.proxy.config;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

import ru.yandex.msearch.proxy.mail.SearchFilter;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public abstract class AbstractFiltersConfigBuilder
    <T extends AbstractFiltersConfigBuilder<T>>
    implements FiltersConfig
{
    public Map<String, SearchFilter> filters;

    protected AbstractFiltersConfigBuilder(final FiltersConfig config) {
        filters = new HashMap<>(config.filters());
    }

    protected AbstractFiltersConfigBuilder(
        final IniConfig config,
        final FiltersConfig defaults)
        throws ConfigException
    {
        Set<String> keys = config.keys();
        filters = new HashMap<>(keys.size() << 1);
        for (String key: keys) {
            filters.put(key, new SearchFilter(config.getString(key)));
        }
    }

    public abstract T self();

    @Override
    public Map<String, SearchFilter> filters() {
        return filters;
    }

    public T rawFilters(final Map<String, String> filters) {
        this.filters = new LinkedHashMap<>(filters.size());
        for (Map.Entry<String, String> entry: filters.entrySet()) {
            this.filters.put(
                entry.getKey(),
                new SearchFilter(entry.getValue()));
        }

        return self();
    }

    public T filters(final Map<String, SearchFilter> filters) {
        this.filters = filters;
        return self();
    }
}
