package ru.yandex.msearch.proxy.config;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public abstract class AbstractMailSuggestConfigBuilder
    <T extends AbstractMailSuggestConfigBuilder<T>>
     implements MailSuggestConfig
{
    private String mailSuggestRelevanceModel;
    private int minSymbols;
    private int count;
    private int minSymbolsExp;

    protected AbstractMailSuggestConfigBuilder(final MailSuggestConfig config) {
        mailSuggestRelevanceModel(config.mailSuggestRelevanceModel());
        minSymbols(config.minSymbols());
        count(config.count());
    }

    protected AbstractMailSuggestConfigBuilder(
        final IniConfig config,
        final MailSuggestConfig defaults)
        throws ConfigException
    {
        this.mailSuggestRelevanceModel =
            config.getString(
                "relevance-model",
                defaults.mailSuggestRelevanceModel());
        this.minSymbols = config.getInt("min-symbols", defaults.minSymbols());
        this.count = config.getInt("count", defaults.count());
        this.minSymbolsExp =
            config.getInt("min-symbols-exp", defaults.minSymbolsExp());
    }

    @Override()
    public String mailSuggestRelevanceModel() {
        return mailSuggestRelevanceModel;
    }

    public T mailSuggestRelevanceModel(final String value) {
        this.mailSuggestRelevanceModel = value;
        return self();
    }

    @Override()
    public int minSymbols() {
        return minSymbols;
    }

    public T minSymbols(final int value) {
        this.minSymbols = value;
        return self();
    }

    @Override()
    public int count() {
        return count;
    }

    public T count(final int value) {
        this.count = value;
        return self();
    }

    protected abstract T self();

    @Override()
    public int minSymbolsExp() {
        return minSymbolsExp;
    }

    public T minSymbolsExp(final int value) {
        this.minSymbolsExp = value;
        return self();
    }
}
