package ru.yandex.msearch.proxy.config;

import java.util.regex.Pattern;

import ru.yandex.client.tvm2.Tvm2ClientConfig;
import ru.yandex.client.tvm2.Tvm2ClientConfigBuilder;
import ru.yandex.erratum.ErratumConfig;
import ru.yandex.erratum.ErratumConfigBuilder;
import ru.yandex.http.config.FilterSearchConfig;
import ru.yandex.http.config.FilterSearchConfigBuilder;
import ru.yandex.http.config.HttpHostConfig;
import ru.yandex.http.config.HttpHostConfigBuilder;
import ru.yandex.http.config.HttpTargetConfig;
import ru.yandex.http.config.HttpTargetConfigBuilder;
import ru.yandex.http.config.URIConfig;
import ru.yandex.http.config.URIConfigBuilder;
import ru.yandex.logger.LoggerConfig;
import ru.yandex.logger.LoggerConfigBuilder;
import ru.yandex.msearch.proxy.api.async.mail.classification.ClassificationConfig;
import ru.yandex.msearch.proxy.api.async.mail.classification.ClassificationConfigBuilder;
import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;
import ru.yandex.passport.search.config.MultisearchConfig;
import ru.yandex.passport.search.config.MultisearchConfigBuilder;
import ru.yandex.search.msal.pool.AddressPgConfig;
import ru.yandex.search.msal.pool.AddressPgConfigBuilder;
import ru.yandex.search.msal.pool.AddressPgConfigDefaults;
import ru.yandex.stater.StaterConfig;
import ru.yandex.stater.StaterConfigBuilder;

public abstract class AbstractMsearchProxyConfigBuilder
    <T extends AbstractMsearchProxyConfigBuilder<T>>
    extends AbstractAsyncHttpServerBaseConfigBuilder<T>
    implements MsearchProxyConfig
{
    private LoggerConfigBuilder errorLogConfig;
    private FactorsLogConfigBuilder tskvLogConfig;
    private FilterSearchConfigBuilder threadsConfig;
    private URIConfigBuilder labelsConfig;
    private FilterSearchConfigBuilder corpFilterSearchConfig;
    private URIConfigBuilder corpLabelsConfig;
    private URIConfigBuilder corpFoldersConfig;
    private HttpHostConfigBuilder blackboxConfig;
    private Tvm2ClientConfigBuilder blackboxTvm2ClientConfig;
    private HttpHostConfigBuilder corpBlackboxConfig;
    private Tvm2ClientConfigBuilder corpBlackboxTvm2ClientConfig;
    private Tvm2ClientConfigBuilder corpFilterSearchTvm2ClientConfig;
    private HttpHostConfigBuilder userSplitConfig;
    private HttpHostConfigBuilder corpMlConfig;
    private HttpHostConfigBuilder iexProxyConfig;
    private FiltersConfigBuilder filtersConfig;
    private EnlargeConfigBuilder enlargeConfig;
    private StaterConfigBuilder backendsResponsesStaterConfig;
    private StaterConfigBuilder filterSearchResponsesStaterConfig;
    private StaterConfigBuilder searchBackendsResolveResponsesStaterConfig;
    private StaterConfigBuilder searchFilterMailSearchStaterConfig;
    private SoCheckConfigBuilder soCheckConfig;
    private ErratumConfigBuilder erratumConfig;
    private SuggestConfigBuilder suggestConfig;
    private RankingConfigBuilder rankingConfig;
    private SubscriptionsConfigBuilder subscriptionsConfig;
    private HttpTargetConfigBuilder proxyConfig;
    private ClassificationConfigBuilder classificationConfig;
    private ChemodanConfigBuilder chemodanConfig;
    private Pattern forbiddenRequests;
    private boolean pureSearch;
    private boolean indexSearchRequests;
    private boolean queryLanguage;
    private boolean topRelevant;
    private String pgQueue;
    private String pgCorpQueue;
    private String oracleQueue;
    private String oracleCorpQueue;
    private long failoverSearchDelay;
    private long sendersFailoverDelay;
    private int syncServerThreads;
    private int syncServerQueueSize;
    private int maxExpectedSearchBackends;
    private HttpTargetConfigBuilder keyboardBackendConfig;
    private String keyboardOAuthScope;
    private DkimStatsConfigBuilder dkimStatsConfig;
    private MultisearchConfigBuilder multisearchConfig;
    private AddressPgConfigBuilder pgPoolConfig;

    protected AbstractMsearchProxyConfigBuilder(final MsearchProxyConfig config) {
        super(config);
        errorLogConfig(config.errorLogConfig());
        tskvLogConfig(config.tskvLogConfig());
        filterSearchConfig(config.filterSearchConfig());
        threadsConfig(config.threadsConfig());
        labelsConfig(config.labelsConfig());
        foldersConfig(config.foldersConfig());
        corpFilterSearchConfig(config.corpFilterSearchConfig());
        corpLabelsConfig(config.corpLabelsConfig());
        corpFoldersConfig(config.corpFoldersConfig());
        blackboxConfig(config.blackboxConfig());
        blackboxTvm2ClientConfig(config.blackboxTvm2ClientConfig());
        corpBlackboxConfig(config.corpBlackboxConfig());
        corpBlackboxTvm2ClientConfig(config.corpBlackboxTvm2ClientConfig());

        filterSearchTvm2ClientConfig(config.filterSearchTvm2ClientConfig());
        corpFilterSearchTvm2ClientConfig(
            config.corpFilterSearchTvm2ClientConfig());

        filtersConfig(config.filtersConfig());
        enlargeConfig(config.enlargeConfig());
        backendsResponsesStaterConfig(config.backendsResponsesStaterConfig());
        searchFilterMailSearchStaterConfig(
            config.searchFilterMailSearchStaterConfig());
        filterSearchResponsesStaterConfig(
            config.filterSearchResponsesStaterConfig());
        searchBackendsResolveResponsesStaterConfig(
            config.searchBackendsResolveResponsesStaterConfig());
        soCheckConfig(config.soCheckConfig());
        erratumConfig(config.erratumConfig());
        forbiddenRequests(config.forbiddenRequests());
        pureSearch(config.pureSearch());
        indexSearchRequests(config.indexSearchRequests());
        queryLanguage(config.queryLanguage());
        topRelevant(config.topRelevant());
        pgQueue(config.pgQueue());
        pgCorpQueue(config.pgCorpQueue());
        oracleQueue(config.oracleQueue());
        oracleCorpQueue(config.oracleCorpQueue());
        failoverSearchDelay(config.failoverSearchDelay());
        sendersFailoverDelay(config.sendersFailoverDelay());
        syncServerThreads(config.syncServerThreads());
        syncServerQueueSize(config.syncServerQueueSize());
        maxExpectedSearchBackends(config.maxExpectedSearchBackends());
        rankingConfig(config.rankingConfig());
        suggestConfig(config.suggestConfig());
        userSplitConfig(config.userSplitConfig());
        iexProxyConfig(config.iexProxyConfig());
        proxyConfig(config.proxyConfig());
        keyboardBackendConfig(config.keyboardBackendConfig());
        keyboardOAuthScope(config.keyboardOAuthScope());
        subscriptionsConfig(config.subscriptionsConfig());
        producerStoreConfig(config.producerStoreConfig());
        mopsClientConfig(config.mopsClientConfig());
        classificationConfig(config.classificationConfig());
        chemodanConfig(config.chemodanConfig());
        corpMlConfig(config.corpMlConfig());
        dkimStatsConfig(config.dkimStatsConfig());
        tupitaConfig(config.tupitaConfig());
        furitaConfig(config.furitaConfig());
        multisearchConfig(config.multisearchConfig());
        pgPoolConfig(config.pgPoolConfig());
    }

    protected AbstractMsearchProxyConfigBuilder(
        final IniConfig config,
        final MsearchProxyConfig defaults)
        throws ConfigException
    {
        super(config, defaults);
        errorLogConfig = new LoggerConfigBuilder(
            config.section("error_log"),
            defaults.errorLogConfig());
        if (config.sectionOrNull("tskv_log") == null) {
            tskvLogConfig = null;
        } else {
            tskvLogConfig = new FactorsLogConfigBuilder(
                config.section("tskv_log"),
                defaults.tskvLogConfig());
        }

        threadsConfig = new FilterSearchConfigBuilder(
            config.section("threads-info"),
            defaults.threadsConfig());
        labelsConfig = new URIConfigBuilder(
            config.section("labels"),
            defaults.labelsConfig());

        IniConfig corpFilterSearchSection = config.section("corp-filter-search");

        corpFilterSearchTvm2ClientConfig = new Tvm2ClientConfigBuilder(
            corpFilterSearchSection.section("tvm2"),
            defaults.corpFilterSearchTvm2ClientConfig());

        corpFilterSearchConfig = new FilterSearchConfigBuilder(
            corpFilterSearchSection,
            defaults.corpFilterSearchConfig());

        corpLabelsConfig = new URIConfigBuilder(
            config.section("corp-labels"),
            defaults.corpLabelsConfig());
        corpFoldersConfig = new URIConfigBuilder(
            config.section("corp-folders"),
            defaults.corpFoldersConfig());
        IniConfig blackboxSection = config.section("blackbox");
        blackboxConfig = new HttpHostConfigBuilder(
            blackboxSection,
            defaults.blackboxConfig());
        blackboxTvm2ClientConfig = new Tvm2ClientConfigBuilder(
            blackboxSection.section("tvm2"),
            defaults.blackboxTvm2ClientConfig());
        IniConfig corpBlackboxSection = config.section("corp-blackbox");
        corpBlackboxConfig = new HttpHostConfigBuilder(
            corpBlackboxSection,
            defaults.corpBlackboxConfig());
        corpBlackboxTvm2ClientConfig = new Tvm2ClientConfigBuilder(
            corpBlackboxSection.section("tvm2"),
            defaults.corpBlackboxTvm2ClientConfig());
        corpMlConfig = new HttpHostConfigBuilder(
            config.section("ml"),
            defaults.corpMlConfig());
        filtersConfig = new FiltersConfigBuilder(
            config.section("search-filters"),
            defaults.filtersConfig());
        enlargeConfig = new EnlargeConfigBuilder(
            config.section("enlarge-your"),
            defaults.enlargeConfig());
        backendsResponsesStaterConfig = new StaterConfigBuilder(
            config.section("backends-responses-stat"),
            defaults.backendsResponsesStaterConfig());
        filterSearchResponsesStaterConfig = new StaterConfigBuilder(
            config.section("filter-search-responses-stat"),
            defaults.filterSearchResponsesStaterConfig());
        searchBackendsResolveResponsesStaterConfig = new StaterConfigBuilder(
            config.section("backends-resolve-responses-stat"),
            defaults.searchBackendsResolveResponsesStaterConfig());
        searchFilterMailSearchStaterConfig = new StaterConfigBuilder(
            config.section("search-filter-stat"),
            defaults.searchFilterMailSearchStaterConfig());

        IniConfig chemodanSection = config.sectionOrNull("chemodan");
        if (chemodanSection != null) {
            chemodanConfig = new ChemodanConfigBuilder(
                chemodanSection,
                defaults.chemodanConfig());
        } else {
            chemodanConfig =
                new ChemodanConfigBuilder(defaults.chemodanConfig());
        }

        IniConfig proxySection = config.sectionOrNull("proxy");
        if (proxySection == null) {
            proxyConfig = new HttpTargetConfigBuilder(defaults.proxyConfig());
            proxyConfig.connections(workers());
        } else {
            proxyConfig =
                new HttpTargetConfigBuilder(
                    proxySection,
                    defaults.proxyConfig());
        }

        IniConfig soCheckSection = config.sectionOrNull("socheck");
        if (soCheckSection == null) {
            soCheckConfig = null;
        } else {
            soCheckConfig = new SoCheckConfigBuilder(
                soCheckSection,
                defaults.soCheckConfig());
        }

        IniConfig erratumSection = config.sectionOrNull("erratum");
        if (erratumSection == null) {
            erratumConfig = null;
        } else {
            erratumConfig = new ErratumConfigBuilder(
                erratumSection,
                defaults.erratumConfig());
        }

        IniConfig userSplitSection = config.sectionOrNull("user-split");
        if (userSplitSection == null) {
            userSplitConfig = null;
        } else {
            userSplitConfig = new HttpHostConfigBuilder(
                userSplitSection,
                defaults.userSplitConfig());
        }

        IniConfig iexProxySection = config.sectionOrNull("iex-proxy");
        if (iexProxySection == null) {
            iexProxyConfig = null;
        } else {
            iexProxyConfig = new HttpHostConfigBuilder(
                iexProxySection,
                defaults.iexProxyConfig());
        }

        IniConfig suggestSection = config.sectionOrNull("suggest");
        if (suggestSection == null) {
            suggestConfig = new SuggestConfigBuilder(defaults.suggestConfig());
        } else {
            suggestConfig = new SuggestConfigBuilder(
                suggestSection,
                defaults.suggestConfig());
        }

        IniConfig subscriptionsSection = config.sectionOrNull("subscriptions");
        if (subscriptionsSection == null) {
            subscriptionsConfig =
                new SubscriptionsConfigBuilder(defaults.subscriptionsConfig());
        } else {
            subscriptionsConfig = new SubscriptionsConfigBuilder(
                subscriptionsSection,
                defaults.subscriptionsConfig());
        }


        IniConfig classificationSection =
            config.sectionOrNull("classification");
        if (classificationSection == null) {
            classificationConfig =
                new ClassificationConfigBuilder(
                    defaults.classificationConfig());
        } else {
            classificationConfig =
                new ClassificationConfigBuilder(
                    classificationSection,
                    defaults.classificationConfig());
        }

        IniConfig multisearch =
            config.sectionOrNull("multisearch");
        if (multisearch == null) {
            multisearchConfig = null;
        } else {
            multisearchConfig =
                new MultisearchConfigBuilder(
                    multisearch);
        }

        rankingConfig = new RankingConfigBuilder(
            config,
            defaults.rankingConfig());

        forbiddenRequests = config.get(
            "forbidden_requests",
            defaults.forbiddenRequests(),
            Pattern::compile);
        pureSearch = config.getBoolean("pure-search", defaults.pureSearch());
        indexSearchRequests = config.getBoolean(
            "index_search_requests",
            defaults.indexSearchRequests());
        queryLanguage = config.getBoolean(
            "query-language",
            defaults.queryLanguage());
        topRelevant = config.getBoolean(
            "top-relevant",
            defaults.topRelevant());

        pgQueue = PG_QUEUE.extract(config, defaults.pgQueue());
        pgCorpQueue = PG_CORP_QUEUE.extract(config, defaults.pgCorpQueue());
        oracleQueue = ORACLE_QUEUE.extract(config, defaults.oracleQueue());
        oracleCorpQueue =
            ORACLE_CORP_QUEUE.extract(config, defaults.oracleCorpQueue());
        failoverSearchDelay = FAILOVER_SEARCH_DELAY.extract(
            config,
            defaults.failoverSearchDelay());
        sendersFailoverDelay = SENDERS_FAILOVER_DELAY.extract(
            config,
            defaults.sendersFailoverDelay());
        syncServerThreads = SYNC_SERVER_THREADS.extract(
            config,
            defaults.syncServerThreads());
        syncServerQueueSize = SYNC_SERVER_QUEUE_SIZE.extract(
            config,
            defaults.syncServerQueueSize());
        maxExpectedSearchBackends = MAX_EXPECTED_SEARCH_BACKENDS.extract(
            config,
            defaults.maxExpectedSearchBackends());

        IniConfig keyboardSection = config.section("keyboard");
        keyboardBackendConfig = new HttpTargetConfigBuilder(
            keyboardSection,
            defaults.keyboardBackendConfig());
        keyboardOAuthScope = KEYBOARD_OAUTH_SCOPE.extract(
            keyboardSection,
            defaults.keyboardOAuthScope());

        dkimStatsConfig =
            DKIM_STATS_CONFIG.extract(config, defaults.dkimStatsConfig());

        IniConfig pgSection = config.section("database.postgresql");
        if (pgSection != null) {
            pgPoolConfig = new AddressPgConfigBuilder(pgSection, AddressPgConfigDefaults.INSTANCE);
        } else {
            pgPoolConfig = null;
        }
    }

    @Override
    public LoggerConfigBuilder errorLogConfig() {
        return errorLogConfig;
    }

    public T errorLogConfig(final LoggerConfig errorLogConfig) {
        this.errorLogConfig = new LoggerConfigBuilder(errorLogConfig);
        return self();
    }

    @Override
    public FactorsLogConfigBuilder tskvLogConfig() {
        return tskvLogConfig;
    }

    public T tskvLogConfig(final FactorsLogConfig tskvLogConfig) {
        if (tskvLogConfig != null) {
            this.tskvLogConfig = new FactorsLogConfigBuilder(tskvLogConfig);
        } else {
            this.tskvLogConfig = null;
        }

        return self();
    }

    @Override
    public FilterSearchConfigBuilder threadsConfig() {
        return threadsConfig;
    }

    public T threadsConfig(final FilterSearchConfig threadsConfig) {
        this.threadsConfig =
            new FilterSearchConfigBuilder(threadsConfig);
        return self();
    }

    @Override
    public URIConfigBuilder labelsConfig() {
        return labelsConfig;
    }

    public T labelsConfig(final URIConfig labelsConfig) {
        this.labelsConfig = new URIConfigBuilder(labelsConfig);
        return self();
    }

    @Override
    public FilterSearchConfigBuilder corpFilterSearchConfig() {
        return corpFilterSearchConfig;
    }

    public T corpFilterSearchConfig(
        final FilterSearchConfig corpFilterSearchConfig)
    {
        this.corpFilterSearchConfig =
            new FilterSearchConfigBuilder(corpFilterSearchConfig);
        return self();
    }

    @Override
    public URIConfigBuilder corpLabelsConfig() {
        return corpLabelsConfig;
    }

    public T corpLabelsConfig(final URIConfig corpLabelsConfig) {
        this.corpLabelsConfig = new URIConfigBuilder(corpLabelsConfig);
        return self();
    }

    @Override
    public URIConfigBuilder corpFoldersConfig() {
        return corpFoldersConfig;
    }

    public T corpFoldersConfig(final URIConfig corpFoldersConfig) {
        this.corpFoldersConfig = new URIConfigBuilder(corpFoldersConfig);
        return self();
    }

    @Override
    public HttpHostConfigBuilder blackboxConfig() {
        return blackboxConfig;
    }

    public T blackboxConfig(final HttpHostConfig blackboxConfig) {
        this.blackboxConfig = new HttpHostConfigBuilder(blackboxConfig);
        return self();
    }

    @Override
    public Tvm2ClientConfigBuilder blackboxTvm2ClientConfig() {
        return blackboxTvm2ClientConfig;
    }

    public T blackboxTvm2ClientConfig(
        final Tvm2ClientConfig blackboxTvm2ClientConfig)
    {
        this.blackboxTvm2ClientConfig =
            new Tvm2ClientConfigBuilder(blackboxTvm2ClientConfig);
        return self();
    }

    @Override
    public HttpHostConfigBuilder corpBlackboxConfig() {
        return corpBlackboxConfig;
    }

    public T corpBlackboxConfig(final HttpHostConfig corpBlackboxConfig) {
        this.corpBlackboxConfig =
            new HttpHostConfigBuilder(corpBlackboxConfig);
        return self();
    }

    @Override
    public Tvm2ClientConfigBuilder corpBlackboxTvm2ClientConfig() {
        return corpBlackboxTvm2ClientConfig;
    }

    public T corpBlackboxTvm2ClientConfig(
        final Tvm2ClientConfig corpBlackboxTvm2ClientConfig)
    {
        this.corpBlackboxTvm2ClientConfig =
            new Tvm2ClientConfigBuilder(corpBlackboxTvm2ClientConfig);
        return self();
    }

    @Override
    public Tvm2ClientConfigBuilder corpFilterSearchTvm2ClientConfig() {
        return corpFilterSearchTvm2ClientConfig;
    }

    public T corpFilterSearchTvm2ClientConfig(
        final Tvm2ClientConfig corpFilterSearchTvm2ClientConfig)
    {
        this.corpFilterSearchTvm2ClientConfig =
            new Tvm2ClientConfigBuilder(corpFilterSearchTvm2ClientConfig);
        return self();
    }

    @Override
    public FiltersConfigBuilder filtersConfig() {
        return filtersConfig;
    }

    public T filtersConfig(final FiltersConfig filtersConfig) {
        this.filtersConfig = new FiltersConfigBuilder(filtersConfig);
        return self();
    }

    @Override
    public EnlargeConfigBuilder enlargeConfig() {
        return enlargeConfig;
    }

    public T enlargeConfig(final EnlargeConfig enlargeConfig) {
        this.enlargeConfig = new EnlargeConfigBuilder(enlargeConfig);
        return self();
    }

    @Override
    public StaterConfigBuilder backendsResponsesStaterConfig() {
        return backendsResponsesStaterConfig;
    }

    public T backendsResponsesStaterConfig(
        final StaterConfig backendsResponsesStaterConfig)
    {
        this.backendsResponsesStaterConfig =
            new StaterConfigBuilder(backendsResponsesStaterConfig);
        return self();
    }

    @Override
    public StaterConfigBuilder filterSearchResponsesStaterConfig() {
        return filterSearchResponsesStaterConfig;
    }

    public T filterSearchResponsesStaterConfig(
        final StaterConfig filterSearchResponsesStaterConfig)
    {
        this.filterSearchResponsesStaterConfig =
            new StaterConfigBuilder(filterSearchResponsesStaterConfig);
        return self();
    }

    @Override
    public StaterConfigBuilder searchBackendsResolveResponsesStaterConfig() {
        return searchBackendsResolveResponsesStaterConfig;
    }

    public T searchBackendsResolveResponsesStaterConfig(
        final StaterConfig searchBackendsResolveResponsesStaterConfig)
    {
        this.searchBackendsResolveResponsesStaterConfig =
            new StaterConfigBuilder(
                searchBackendsResolveResponsesStaterConfig);
        return self();
    }

    @Override
    public SoCheckConfigBuilder soCheckConfig() {
        return soCheckConfig;
    }

    public T soCheckConfig(final SoCheckConfig soCheckConfig) {
        if (soCheckConfig == null) {
            this.soCheckConfig = null;
        } else {
            this.soCheckConfig = new SoCheckConfigBuilder(soCheckConfig);
        }
        return self();
    }

    @Override
    public SuggestConfigBuilder suggestConfig() {
        return suggestConfig;
    }

    public T suggestConfig(final SuggestConfig suggestConfig) {
        if (suggestConfig== null) {
            this.suggestConfig = null;
        } else {
            this.suggestConfig = new SuggestConfigBuilder(suggestConfig);
        }
        return self();
    }

    @Override
    public ErratumConfigBuilder erratumConfig() {
        return erratumConfig;
    }

    public T erratumConfig(final ErratumConfig erratumConfig) {
        if (erratumConfig == null) {
            this.erratumConfig = null;
        } else {
            this.erratumConfig = new ErratumConfigBuilder(erratumConfig);
        }
        return self();
    }

    @Override
    public HttpHostConfigBuilder userSplitConfig() {
        return userSplitConfig;
    }

    public T userSplitConfig(final HttpHostConfig config) {
        if (config == null) {
            this.userSplitConfig = null;
        } else {
            this.userSplitConfig = new HttpHostConfigBuilder(config);
        }

        return self();
    }

    @Override
    public HttpHostConfigBuilder iexProxyConfig() {
        return iexProxyConfig;
    }

    public T iexProxyConfig(final HttpHostConfig config) {
        if (config == null) {
            this.iexProxyConfig = null;
        } else {
            this.iexProxyConfig = new HttpHostConfigBuilder(config);
        }
        return self();
    }

    @Override
    public Pattern forbiddenRequests() {
        return forbiddenRequests;
    }

    public T forbiddenRequests(final Pattern forbiddenRequests) {
        this.forbiddenRequests = forbiddenRequests;
        return self();
    }

    @Override
    public boolean pureSearch() {
        return pureSearch;
    }

    public T pureSearch(final boolean pureSearch) {
        this.pureSearch = pureSearch;
        return self();
    }

    @Override
    public boolean indexSearchRequests() {
        return indexSearchRequests;
    }

    public T indexSearchRequests(final boolean indexSearchRequests) {
        this.indexSearchRequests = indexSearchRequests;
        return self();
    }

    @Override
    public boolean queryLanguage() {
        return queryLanguage;
    }

    public T queryLanguage(final boolean queryLanguage) {
        this.queryLanguage = queryLanguage;
        return self();
    }

    @Override
    public boolean topRelevant() {
        return topRelevant;
    }

    public T topRelevant(final boolean topRelevant) {
        this.topRelevant = topRelevant;
        return self();
    }

    @Override
    public String pgQueue() {
        return pgQueue;
    }

    public T pgQueue(final String pgQueue) {
        this.pgQueue = pgQueue;
        return self();
    }

    @Override
    public String pgCorpQueue() {
        return pgCorpQueue;
    }

    public T pgCorpQueue(final String pgCorpQueue) {
        this.pgCorpQueue = pgCorpQueue;
        return self();
    }

    @Override
    public String oracleQueue() {
        return oracleQueue;
    }

    public T oracleQueue(final String oracleQueue) {
        this.oracleQueue = oracleQueue;
        return self();
    }

    @Override
    public String oracleCorpQueue() {
        return oracleCorpQueue;
    }

    public T oracleCorpQueue(final String oracleCorpQueue) {
        this.oracleCorpQueue = oracleCorpQueue;
        return self();
    }

    @Override
    public long failoverSearchDelay() {
        return failoverSearchDelay;
    }

    public T failoverSearchDelay(final long failoverSearchDelay) {
        this.failoverSearchDelay = failoverSearchDelay;
        return self();
    }

    @Override
    public long sendersFailoverDelay() {
        return sendersFailoverDelay;
    }

    public T sendersFailoverDelay(final long sendersFailoverDelay) {
        this.sendersFailoverDelay = sendersFailoverDelay;
        return self();
    }

    @Override
    public int syncServerThreads() {
        return syncServerThreads;
    }

    public T syncServerThreads(final int syncServerThreads) {
        this.syncServerThreads = syncServerThreads;
        return self();
    }

    @Override
    public int syncServerQueueSize() {
        return syncServerQueueSize;
    }

    public T syncServerQueueSize(final int syncServerQueueSize) {
        this.syncServerQueueSize = syncServerQueueSize;
        return self();
    }

    @Override
    public int maxExpectedSearchBackends() {
        return maxExpectedSearchBackends;
    }

    public T maxExpectedSearchBackends(final int maxExpectedSearchBackends) {
        this.maxExpectedSearchBackends = maxExpectedSearchBackends;
        return self();
    }

    @Override
    public RankingConfigBuilder rankingConfig() {
        return rankingConfig;
    }

    public T rankingConfig(final RankingConfig config) {
        this.rankingConfig = new RankingConfigBuilder(config);
        return self();
    }

    @Override
    public HttpTargetConfigBuilder proxyConfig() {
        return proxyConfig;
    }

    public T proxyConfig(final HttpTargetConfig config) {
        this.proxyConfig = new HttpTargetConfigBuilder(config);
        return self();
    }

    @Override
    public HttpTargetConfigBuilder keyboardBackendConfig() {
        return keyboardBackendConfig;
    }

    public T keyboardBackendConfig(
        final HttpTargetConfig keyboardBackendConfig)
    {
        this.keyboardBackendConfig =
            new HttpTargetConfigBuilder(keyboardBackendConfig);
        return self();
    }

    @Override
    public String keyboardOAuthScope() {
        return keyboardOAuthScope;
    }

    public T keyboardOAuthScope(final String keyboardOAuthScope) {
        this.keyboardOAuthScope = keyboardOAuthScope;
        return self();
    }

    @Override
    public SubscriptionsConfigBuilder subscriptionsConfig() {
        return subscriptionsConfig;
    }

    public T subscriptionsConfig(
        final SubscriptionsConfig subscriptionsConfig)
    {
        this.subscriptionsConfig =
            new SubscriptionsConfigBuilder(subscriptionsConfig);
        return self();
    }

    @Override
    public ClassificationConfigBuilder classificationConfig() {
        return classificationConfig;
    }

    public T classificationConfig(final ClassificationConfig config) {
        this.classificationConfig = new ClassificationConfigBuilder(config);
        return self();
    }

    @Override
    public ChemodanConfigBuilder chemodanConfig() {
        return chemodanConfig;
    }

    public T chemodanConfig(final ChemodanConfig config) {
        this.chemodanConfig = new ChemodanConfigBuilder(config);
        return self();
    }

    @Override
    public StaterConfigBuilder searchFilterMailSearchStaterConfig() {
        return searchFilterMailSearchStaterConfig;
    }

    public T searchFilterMailSearchStaterConfig(
        final StaterConfig config)
    {
        this.searchFilterMailSearchStaterConfig =
            new StaterConfigBuilder(config);
        return self();
    }

    @Override
    public HttpHostConfigBuilder corpMlConfig() {
        return corpMlConfig;
    }

    public T corpMlConfig(final HttpHostConfig config) {
        this.corpMlConfig = new HttpHostConfigBuilder(config);
        return self();
    }

    @Override
    public DkimStatsConfigBuilder dkimStatsConfig() {
        return dkimStatsConfig;
    }

    public T dkimStatsConfig(final DkimStatsConfig dkimStatsConfig) {
        if (dkimStatsConfig == null) {
            this.dkimStatsConfig = null;
        } else {
            this.dkimStatsConfig = new DkimStatsConfigBuilder(dkimStatsConfig);
        }
        return self();
    }

    public MultisearchConfigBuilder multisearchConfig() {
        return multisearchConfig;
    }

    public T multisearchConfig(final MultisearchConfig config) {
        if (config == null) {
            this.multisearchConfig = null;
        } else {
            this.multisearchConfig = new MultisearchConfigBuilder(config);
        }
        return self();
    }

    public AddressPgConfigBuilder pgPoolConfig() {
        return pgPoolConfig;
    }

    public T pgPoolConfig(final AddressPgConfig config) {
        if (config == null) {
            this.pgPoolConfig = null;
        } else {
            this.pgPoolConfig = new AddressPgConfigBuilder(config);
        }
        return self();
    }
}

