package ru.yandex.msearch.proxy.config;

import ru.yandex.http.config.AbstractURIConfigBuilder;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

import ru.yandex.parser.string.NonEmptyValidator;
import ru.yandex.parser.string.PositiveLongValidator;

public abstract class AbstractSoCheckConfigBuilder
    <T extends AbstractSoCheckConfigBuilder<T>>
    extends AbstractURIConfigBuilder<T>
    implements SoCheckConfig
{
    private boolean banSpam;
    private String fakeRequest;
    private long fakeRequestInterval;

    protected AbstractSoCheckConfigBuilder(final SoCheckConfig config) {
        super(config);
        banSpam = config.banSpam();
        fakeRequest = config.fakeRequest();
        fakeRequestInterval = config.fakeRequestInterval();
    }

    protected AbstractSoCheckConfigBuilder(
        final IniConfig config,
        final SoCheckConfig defaults)
        throws ConfigException
    {
        super(config, defaults);
        banSpam = config.getBoolean("ban_spam", defaults.banSpam());
        if (banSpam) {
            fakeRequest = config.get(
                "fake_request",
                defaults.fakeRequest(),
                NonEmptyValidator.INSTANCE);
            if (fakeRequest != null) {
                fakeRequestInterval = config.get(
                    "fake_request_interval",
                    defaults.fakeRequestInterval(),
                    PositiveLongValidator.INSTANCE);
            }
        }
    }

    @Override
    public boolean banSpam() {
        return banSpam;
    }

    public T banSpam(final boolean banSpam) {
        this.banSpam = banSpam;
        return self();
    }

    @Override
    public String fakeRequest() {
        return fakeRequest;
    }

    public T fakeRequest(final String fakeRequest) {
        this.fakeRequest = fakeRequest;
        return self();
    }

    @Override
    public long fakeRequestInterval() {
        return fakeRequestInterval;
    }

    public T fakeRequestInterval(final long fakeRequestInterval) {
        this.fakeRequestInterval = fakeRequestInterval;
        return self();
    }
}
