package ru.yandex.msearch.proxy.config;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

/**
 * Abstract config builder for suggest service
 *
 */
public abstract class AbstractSubjectSuggestConfigBuilder<T extends
    AbstractSubjectSuggestConfigBuilder<T>> implements
    SubjectSuggestConfig
{
    private boolean enabled;
    private boolean responseOnEmptyRequest;
    private int limit;
    private int subjectMinimumWordLength;
    private int minimumRequestLenToMorpho;
    private int minimumRequestStoreLen;

    protected AbstractSubjectSuggestConfigBuilder(final SubjectSuggestConfig config) {
        this.enabled = config.enabled();
        this.limit = config.limit();
        this.responseOnEmptyRequest = config.responseOnEmpty();
        this.subjectMinimumWordLength = config.subjectMinimumWordLength();
        this.minimumRequestLenToMorpho = config.minimumRequestLenToMorpho();
        this.minimumRequestStoreLen = config.minimumRequestStoreLen();
    }

    protected AbstractSubjectSuggestConfigBuilder(
        final IniConfig config,
        final SubjectSuggestConfig defaults)
        throws ConfigException
    {
        if (config == null || config.keys().isEmpty()) {
            this.enabled = defaults.enabled();
            this.limit = defaults.limit();
            this.responseOnEmptyRequest = defaults.responseOnEmpty();
            this.subjectMinimumWordLength = defaults.subjectMinimumWordLength();
            this.minimumRequestLenToMorpho = defaults.minimumRequestLenToMorpho();
            this.minimumRequestStoreLen = defaults.minimumRequestStoreLen();
        } else {
            this.enabled = config.getBoolean("enabled", defaults.enabled());
            this.limit = config.getInt("limit", defaults.limit());
            this.responseOnEmptyRequest = config.getBoolean("response_on_empty",
                defaults.responseOnEmpty());
            this.subjectMinimumWordLength = config.getInt(
                "subject_min_word_length",
                defaults.subjectMinimumWordLength());
            this.minimumRequestLenToMorpho = config.getInt(
                "subject_min_morpho_length",
                defaults.minimumRequestLenToMorpho());
            this.minimumRequestStoreLen = config.getInt(
                "history_req_len_store",
                defaults.minimumRequestStoreLen());
        }
    }

    @Override
    public int limit() {
        return limit;
    }

    @Override
    public boolean enabled() {
        return enabled;
    }

    @Override
    public boolean responseOnEmpty() {
        return responseOnEmptyRequest;
    }

    public T enabled(boolean value) {
        this.enabled = value;
        return self();
    }

    public T limit(int value) {
        this.limit = value;
        return self();
    }

    @Override
    public int subjectMinimumWordLength() {
        return subjectMinimumWordLength;
    }

    public T subjectMinimumWordLength(int length) {
        this.subjectMinimumWordLength = length;
        return self();
    }

    @Override
    public int minimumRequestLenToMorpho() {
        return minimumRequestLenToMorpho;
    }

    public T minimumRequestLenToMorpho(int length) {
        this.minimumRequestLenToMorpho = length;
        return self();
    }

    protected abstract T self();

    @Override
    public int minimumRequestStoreLen() {
        return minimumRequestStoreLen;
    }
}
