package ru.yandex.msearch.proxy.config;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public final class AsyncHttpServerBaseConfigBuilder
    extends AbstractAsyncHttpServerBaseConfigBuilder<AsyncHttpServerBaseConfigBuilder>
{
    public AsyncHttpServerBaseConfigBuilder(IniConfig config) throws ConfigException {
        super(config, AsyncHttpServerBaseConfigDefaults.INSTANCE);
    }

    @Override
    public AsyncHttpServerBaseConfigBuilder self() {
        return this;
    }

    public ImmutableAsyncHttpServerBaseConfig build() throws ConfigException {
        return new ImmutableAsyncHttpServerBaseConfig(this);
    }
}
