package ru.yandex.msearch.proxy.config;

import ru.yandex.client.tvm2.Tvm2ClientConfig;
import ru.yandex.client.tvm2.Tvm2ClientConfigDefaults;
import ru.yandex.http.config.FilterSearchConfigDefaults;
import ru.yandex.http.config.HttpHostConfig;
import ru.yandex.http.config.HttpHostConfigDefaults;
import ru.yandex.http.config.URIConfigDefaults;
import ru.yandex.search.proxy.universal.UniversalSearchProxyConfigDefaults;

public class AsyncHttpServerBaseConfigDefaults
    extends UniversalSearchProxyConfigDefaults
    implements AsyncHttpServerBaseConfig
{
    public static final AsyncHttpServerBaseConfigDefaults INSTANCE = new AsyncHttpServerBaseConfigDefaults();

    protected AsyncHttpServerBaseConfigDefaults() {}

    @Override
    public FilterSearchConfigDefaults filterSearchConfig() {
        return FilterSearchConfigDefaults.INSTANCE;
    }

    @Override
    public URIConfigDefaults foldersConfig() {
        return URIConfigDefaults.INSTANCE;
    }

    @Override
    public Tvm2ClientConfig filterSearchTvm2ClientConfig() {
        return Tvm2ClientConfigDefaults.INSTANCE;
    }

    @Override
    public HttpHostConfig producerStoreConfig() {
        return HttpHostConfigDefaults.INSTANCE;
    }

    @Override
    public HttpHostConfig mopsClientConfig() {
        return null;
    }

    @Override
    public HttpHostConfig tupitaConfig() {
        return HttpHostConfigDefaults.INSTANCE;
    }

    @Override
    public HttpHostConfig furitaConfig() {
        return HttpHostConfigDefaults.INSTANCE;
    }
}
