package ru.yandex.msearch.proxy.config;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public class ChemodanConfigBuilder
     extends AbstractChemodanConfigBuilder<ChemodanConfigBuilder>
{
    public ChemodanConfigBuilder() {
        this(ChemodanConfigDefaults.INSTANCE);
    }

    public ChemodanConfigBuilder(final ChemodanConfig config) {
        super(config);
    }

    public ChemodanConfigBuilder(
        final IniConfig config)
        throws ConfigException
    {
        this(config, ChemodanConfigDefaults.INSTANCE);
    }

    public ChemodanConfigBuilder(
        final IniConfig config,
        final ChemodanConfig defaults)
        throws ConfigException
    {
        super(config, defaults);
    }

    public ImmutableChemodanConfig build() throws ConfigException {
        return new ImmutableChemodanConfig(
            this);
    }

    @Override
    public ChemodanConfigBuilder self() {
        return this;
    }
}
