package ru.yandex.msearch.proxy.config;

import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;

public class ChemodanConfigDefaults
     implements ChemodanConfig
{
    public static final ChemodanConfigDefaults INSTANCE =
        new ChemodanConfigDefaults();
    private static final Set<String> PREVIEWABLE_TYPES =
        Collections.unmodifiableSet(
            new LinkedHashSet<>(
                Arrays.asList(
                    "bmp",
                    "jpg",
                    "jpeg",
                    "png",
                    "gif",
                    "tif",
                    "tiff")));

    protected ChemodanConfigDefaults() {
    }

    @Override
    public String webattachUrl() {
        return "http://webattach.mail.yandex.net/message_part_real/";
    }

    @Override
    public String corpWebattachUrl() {
        return "http://webattachcorp.mail.yandex.net/message_part_real/";
    }

    @Override
    public int webattachTtl() {
        return 10800;
    }

    @Override
    public Set<String> previewableExtensions() {
        return PREVIEWABLE_TYPES;
    }

    @Override
    public boolean ps3183Shield() {
        return false;
    }
}
