package ru.yandex.msearch.proxy.config;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public class ContactSuggestConfigBuilder implements ContactSuggestConfig {
    private int maxRequestTime;
    private int limit;
    private int reservedSize;
    private int printkeysCacheSize;
    private int printkeysCacheExpire;
    private int printkeysLimit;
    private int sendersRequestThreshold;

    private boolean enabled;
    private boolean showOnEmptyRequest;
    private boolean sendersEnabled;

    public ContactSuggestConfigBuilder(final ContactSuggestConfig config) {
        this.maxRequestTime(config.maxRequestTime());
        this.limit(config.limit());
        this.enabled(config.enabled());
        this.printkeysCacheSize(config.printkeysCacheSize());
        this.printkeysCacheExpire(config.printkeysCacheExpire());
        this.reservedSize(config.reservedSize());
        this.showOnEmptyRequest(config.showOnEmptyRequest());
        this.sendersEnabled(config.sendersEnabled());
        this.sendersRequestThreshold(config.sendersFastRequestThreshold());
        this.printkeysLimit(config.printkeysLimit());
    }

    public ContactSuggestConfigBuilder(
        final IniConfig config,
        final ContactSuggestConfig defaults)
        throws ConfigException
    {
        this.maxRequestTime = config.getInt(
            "max-request-time",
            defaults.maxRequestTime());

        this.printkeysCacheSize = config.getInt(
            "printkeys_cache_size",
            defaults.printkeysCacheSize());
        this.printkeysCacheExpire = config.getInt(
            "printkeys_cache_expire",
            defaults.printkeysCacheExpire());
        this.printkeysLimit = config.getInt(
            "printkeys_limit",
            defaults.printkeysLimit());

        this.reservedSize = config.getInt(
            "reserved-size",
            defaults.reservedSize());

        this.showOnEmptyRequest =
            config.getBoolean("empty-request", defaults.showOnEmptyRequest());

        this.limit = config.getInt("total_limit", defaults.limit());
        this.enabled = config.getBoolean("enabled", defaults.enabled());
        this.sendersEnabled =
            config.getBoolean("senders-enabled", defaults.enabled());
        this.sendersRequestThreshold =
            config.getInt(
                "senderds-max-request-size",
                defaults.sendersFastRequestThreshold());
    }

    @Override
    public int maxRequestTime() {
        return maxRequestTime;
    }

    public ContactSuggestConfigBuilder maxRequestTime(final int time) {
        this.maxRequestTime = time;
        return this;
    }

    @Override
    public int limit() {
        return limit;
    }

    public ContactSuggestConfigBuilder limit(final int limit) {
        this.limit = limit;
        return this;
    }

    @Override
    public boolean enabled() {
        return enabled;
    }

    public ContactSuggestConfigBuilder enabled(final boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public ImmutableContactSuggestConfig build() {
        return new ImmutableContactSuggestConfig(this);
    }

    @Override
    public int printkeysCacheSize() {
        return printkeysCacheSize;
    }

    public ContactSuggestConfigBuilder printkeysCacheSize(final int size) {
        this.printkeysCacheSize = size;
        return this;
    }

    @Override
    public int printkeysCacheExpire() {
        return printkeysCacheExpire;
    }

    public ContactSuggestConfigBuilder printkeysCacheExpire(final int time) {
        this.printkeysCacheExpire = time;
        return this;
    }

    @Override
    public int reservedSize() {
        return reservedSize;
    }

    public ContactSuggestConfigBuilder reservedSize(final int reservedSize) {
        this.reservedSize = reservedSize;
        return this;
    }

    public boolean showOnEmptyRequest() {
        return showOnEmptyRequest;
    }

    public ContactSuggestConfigBuilder showOnEmptyRequest(
        final boolean showOnEmptyRequest)
    {
        this.showOnEmptyRequest = showOnEmptyRequest;
        return this;
    }

    public boolean sendersEnabled() {
        return sendersEnabled;
    }

    public ContactSuggestConfigBuilder sendersEnabled(
        final boolean sendersEnabled)
    {
        this.sendersEnabled = sendersEnabled;
        return this;
    }

    @Override
    public int sendersFastRequestThreshold() {
        return sendersRequestThreshold;
    }

    public ContactSuggestConfigBuilder sendersRequestThreshold(
        final int sendersRequestThreshold)
    {
        this.sendersRequestThreshold = sendersRequestThreshold;
        return this;
    }

    @Override
    public int printkeysLimit() {
        return printkeysLimit;
    }

    public ContactSuggestConfigBuilder printkeysLimit(
        final int printkeysLimit)
    {
        this.printkeysLimit = printkeysLimit;
        return this;
    }
}
