package ru.yandex.msearch.proxy.config;

public class ContactSuggestConfigDefaults implements ContactSuggestConfig {
    public static final ContactSuggestConfigDefaults INSTANCE
        = new ContactSuggestConfigDefaults();

    private static final boolean DEFAULT_ENABLED = true;
    private static final int DEFAULT_LIMIT = 10;
    private static final int DEFAULT_RESERVED_SIZE = 4;

    private static final int DEFAULT_MAX_REQUEST_TIME = 1950;

    private static final int DEFAULT_PRINTKEYS_CACHE_SIZE = 1000;
    private static final int DEFAULT_PRINTKEYS_CACHE_EXPIRE_MS = 30000;
    private static final int DEFAULT_PRINTKEYS_LIMIT = 10000;

    private static final boolean SENDERS_ENABLED = true;
    private static final int SENDERS_MAX_REQUEST_SIZE = 4;

    @Override
    public int maxRequestTime() {
        return DEFAULT_MAX_REQUEST_TIME;
    }

    @Override
    public int limit() {
        return DEFAULT_LIMIT;
    }

    @Override
    public boolean enabled() {
        return DEFAULT_ENABLED;
    }

    @Override
    public int printkeysCacheSize() {
        return DEFAULT_PRINTKEYS_CACHE_SIZE;
    }

    @Override
    public int printkeysCacheExpire() {
        return DEFAULT_PRINTKEYS_CACHE_EXPIRE_MS;
    }

    @Override
    public int reservedSize() {
        return DEFAULT_RESERVED_SIZE;
    }

    @Override
    public boolean showOnEmptyRequest() {
        return true;
    }

    @Override
    public boolean sendersEnabled() {
        return SENDERS_ENABLED;
    }

    @Override
    public int sendersFastRequestThreshold() {
        return SENDERS_MAX_REQUEST_SIZE;
    }

    @Override
    public int printkeysLimit() {
        return DEFAULT_PRINTKEYS_LIMIT;
    }
}
