package ru.yandex.msearch.proxy.config;

import ru.yandex.function.NullToDefaultFunction;
import ru.yandex.parser.config.ParameterConfig;
import ru.yandex.parser.string.DoubleToLongValidator;
import ru.yandex.parser.string.DurationParser;
import ru.yandex.parser.string.LongMemorySizeParser;
import ru.yandex.parser.string.NonNegativeValidator;
import ru.yandex.parser.string.PositiveValidator;

public interface DkimStatsConfig {
    ParameterConfig<Long> FAILOVER_DELAY = new ParameterConfig<>(
        "failover-delay",
        DurationParser.INSTANCE.andThen(DoubleToLongValidator.INSTANCE),
        new NullToDefaultFunction<>(NonNegativeValidator.instance()),
        true);
    ParameterConfig<Long> CACHE_TTL = new ParameterConfig<>(
        "cache-ttl",
        DurationParser.INSTANCE.andThen(DoubleToLongValidator.INSTANCE),
        NonNegativeValidator.instance());
    ParameterConfig<Long> CACHE_CAPACITY = new ParameterConfig<>(
        "cache-capacity",
        LongMemorySizeParser.INSTANCE,
        NonNegativeValidator.instance());
    ParameterConfig<Integer> UPDATE_CONCURRENCY = new ParameterConfig<>(
        "update-concurrency",
        Integer::valueOf,
        PositiveValidator.instance());
    ParameterConfig<Long> RETRY_INTERVAL = new ParameterConfig<>(
        "retry-interval",
        DurationParser.INSTANCE.andThen(DoubleToLongValidator.INSTANCE),
        NonNegativeValidator.instance());

    Long failoverDelay();

    long cacheTtl();

    long cacheCapacity();

    int updateConcurrency();

    long retryInterval();
}

