package ru.yandex.msearch.proxy.config;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public final class DkimStatsConfigBuilder
    extends AbstractDkimStatsConfigBuilder<DkimStatsConfigBuilder>
{
    public DkimStatsConfigBuilder() {
        this(DkimStatsConfigDefaults.INSTANCE);
    }

    public DkimStatsConfigBuilder(final DkimStatsConfig config) {
        super(config);
    }

    public DkimStatsConfigBuilder(final IniConfig config)
        throws ConfigException
    {
        this(config, DkimStatsConfigDefaults.INSTANCE);
    }

    public DkimStatsConfigBuilder(
        final IniConfig config,
        final DkimStatsConfig defaults)
        throws ConfigException
    {
        super(config, defaults);
    }

    @Override
    public DkimStatsConfigBuilder self() {
        return this;
    }

    public ImmutableDkimStatsConfig build() throws ConfigException {
        return new ImmutableDkimStatsConfig(this);
    }
}

