package ru.yandex.msearch.proxy.config;

import java.util.Map;

import ru.yandex.msearch.proxy.api.async.enlarge.Enlargeble;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public final class EnlargeConfigBuilder
    extends AbstractEnlargeConfigBuilder<EnlargeConfigBuilder>
{
    private Map<String, Enlargeble> enlargebles;

    public EnlargeConfigBuilder() {
        this(EnlargeConfigDefaults.INSTANCE);
    }

    public EnlargeConfigBuilder(final EnlargeConfig config) {
        super(config);
    }

    public EnlargeConfigBuilder(final IniConfig config)
        throws ConfigException
    {
        super(config, EnlargeConfigDefaults.INSTANCE);
    }

    public EnlargeConfigBuilder(
        final IniConfig config,
        final EnlargeConfig defaults)
        throws ConfigException
    {
        super(config, defaults);
    }

    @Override
    public EnlargeConfigBuilder self() {
        return this;
    }

    public ImmutableEnlargeConfig build() throws ConfigException {
        return new ImmutableEnlargeConfig(this);
    }
}
