package ru.yandex.msearch.proxy.config;

import java.util.LinkedHashSet;
import java.util.Set;

import ru.yandex.logger.LoggerConfigBuilder;
import ru.yandex.logger.LoggerFileConfigBuilder;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

import ru.yandex.parser.string.CollectionParser;
import ru.yandex.parser.string.NonEmptyValidator;

public class FactorsLogConfigBuilder
    extends LoggerConfigBuilder
    implements FactorsLogConfig
{
    private Set<String> factors;
    private boolean personal;

    public FactorsLogConfigBuilder() {
        this(FactorsLogConfigDefaults.INSTANCE);
    }

    public FactorsLogConfigBuilder(final FactorsLogConfig config) {
        super(config);

        this.factors(config.factors());
        this.personal(config.personal());
    }

    public FactorsLogConfigBuilder(final IniConfig config)
        throws ConfigException
    {
        this(config, FactorsLogConfigDefaults.INSTANCE);
    }

    public FactorsLogConfigBuilder(
        final IniConfig config,
        final FactorsLogConfig defaults) throws ConfigException
    {
        super(config, defaults);

        factors = config.getAll(
            "factors",
            defaults.factors(),
            new CollectionParser<>(
                NonEmptyValidator.TRIMMED,
                LinkedHashSet::new));

        personal = config.getBoolean("personal", defaults.personal());
    }

    public FactorsLogConfigBuilder factors(final Set<String> factors) {
        this.factors = new LinkedHashSet<>(factors);
        return this;
    }

    public FactorsLogConfigBuilder personal(final boolean personal) {
        this.personal = personal;
        return this;
    }

    @Override
    public Set<String> factors() {
        return factors;
    }

    @Override
    public boolean personal() {
        return personal;
    }
}
