package ru.yandex.msearch.proxy.config;

import java.util.Collections;
import java.util.Map;
import java.util.Set;

import ru.yandex.logger.LoggerConfigInterfaceDefaults;
import ru.yandex.logger.LoggerConfigDefaults;
import ru.yandex.logger.LoggerFileConfig;
import ru.yandex.logger.LoggerFileConfigDefaults;
import ru.yandex.logger.PureLoggerConfigDefaults;

public class FactorsLogConfigDefaults
    extends PureLoggerConfigDefaults
    implements FactorsLogConfig, LoggerConfigInterfaceDefaults
{
    public static final FactorsLogConfigDefaults INSTANCE =
        new FactorsLogConfigDefaults();

    private static final Map<String, ? extends LoggerFileConfig> FILES =
        Collections.singletonMap(
            DEFAULT,
            PureLoggerConfigDefaults.INSTANCE);

    @Override
    public Set<String> factors() {
        return Collections.emptySet();
    }

    @Override
    public boolean personal() {
        return false;
    }

    @Override
    public Map<String, ? extends LoggerFileConfig> files() {
        return FILES;
    }
}
